/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.util.List;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;
import org.simantics.db.Resource;
import org.simantics.scl.compiler.module.coverage.Coverage;
import org.simantics.tests.modelled.ui.CoverageViewSorter;
import org.simantics.tests.modelled.ui.RedGreenBar;
import org.simantics.tests.modelled.ui.STSCounterPanel;
import org.simantics.tests.modelled.ui.STSCoverageProvider;
import org.simantics.tests.modelled.ui.STSExecutionListener;
import org.simantics.tests.modelled.ui.STSProgressBar;
import org.simantics.tests.modelled.ui.STSTestSuiteModel;
import org.simantics.tests.modelled.ui.STSTestSuiteProvider;

public class STSTestRunnerView {
    public static final String ID = "org.simantics.tests.modelled.ui.stsTestRunnerView";
    private Resource test;
    private SashForm sashForm;
    private PageBook viewerbook;
    private TreeViewer treeViewer;
    private STSTestSuiteProvider provider;
    private StyledText output;
    private STSCounterPanel counterPanel;
    private STSProgressBar progressBar;
    private Composite counterComposite;
    protected static final int COLUMN_ELEMENT = 0;
    protected static final int COLUMN_RATIO = 1;
    protected static final int COLUMN_COVERED = 2;
    protected static final int COLUMN_MISSED = 3;
    protected static final int COLUMN_TOTAL = 4;
    private static final int[] DEFAULT_COLUMNWIDTH = new int[]{200, 100, 120, 120, 120};

    @PostConstruct
    void createView(MPart part, Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.counterComposite = this.createProgressCountPanel(parent);
        this.counterComposite.setLayoutData((Object)new GridData(768));
        this.counterComposite.pack();
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
    }

    private SashForm createSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.sashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.createTestViewers((Composite)top);
        top.setContent((Control)this.viewerbook);
        this.treeViewer.setInput((Object)this.test);
        ViewForm bottom = new ViewForm((Composite)this.sashForm, 0);
        CTabFolder folder = new CTabFolder((Composite)bottom, 2048);
        folder.setLayoutData((Object)new GridData(1808));
        CTabItem item1 = new CTabItem(folder, 0);
        item1.setText("Execution");
        this.output = new StyledText((Composite)folder, 778);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.output.setLayoutData((Object)formData);
        item1.setControl((Control)this.output);
        bottom.setContent((Control)folder);
        folder.setSelection(0);
        CTabItem item2 = new CTabItem(folder, 0);
        item2.setText("Coverage");
        Composite treeComposite = new Composite((Composite)folder, 0);
        final TreeViewer viewer = this.createCoverageViewer(treeComposite);
        item2.setControl((Control)treeComposite);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                TreeSelection sel = (TreeSelection)selection;
                List<String> testOutput = STSTestRunnerView.this.provider.getModel().getOutput(sel.getFirstElement());
                viewer.setInput(sel.getFirstElement());
                StringBuilder sb = new StringBuilder();
                for (String o : testOutput) {
                    sb.append(o);
                }
                STSTestRunnerView.this.output.setText(sb.toString());
            }
        });
        this.sashForm.setWeights(new int[]{50, 50});
        return this.sashForm;
    }

    private TreeViewer createCoverageViewer(Composite parent) {
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        Tree tree = new Tree(parent, 65538);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        final STSCoverageProvider provider = new STSCoverageProvider();
        TreeViewer viewer = new TreeViewer(tree);
        CoverageViewSorter sorter = new CoverageViewSorter(viewer);
        TreeViewerColumn column0 = new TreeViewerColumn(viewer, 16384);
        column0.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(provider.getText(cell.getElement()));
                cell.setImage(provider.getImage(cell.getElement()));
            }
        });
        sorter.addColumn(column0, 0);
        final TreeViewerColumn column1 = new TreeViewerColumn(viewer, 131072);
        column1.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(provider.getRatio(cell.getElement()));
            }

            protected void erase(Event event, Object element) {
            }

            protected void measure(Event event, Object element) {
            }

            protected void paint(Event event, Object element) {
                Coverage coverage = (Coverage)element;
                if (coverage != null) {
                    RedGreenBar.draw(event, column1.getColumn().getWidth(), coverage);
                }
            }
        });
        sorter.addColumn(column1, 1);
        TreeViewerColumn column2 = new TreeViewerColumn(viewer, 131072);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(provider.getCovered(cell.getElement()));
            }
        });
        sorter.addColumn(column2, 2);
        TreeViewerColumn column3 = new TreeViewerColumn(viewer, 131072);
        column3.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(provider.getMissed(cell.getElement()));
            }
        });
        sorter.addColumn(column3, 3);
        TreeViewerColumn column4 = new TreeViewerColumn(viewer, 131072);
        column4.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(provider.getTotal(cell.getElement()));
            }
        });
        sorter.addColumn(column4, 4);
        viewer.setComparator((ViewerComparator)sorter);
        layout.setColumnData((Widget)column0.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 50, false));
        layout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 50, false));
        layout.setColumnData((Widget)column2.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 50, false));
        layout.setColumnData((Widget)column3.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 50, false));
        layout.setColumnData((Widget)column4.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 50, false));
        String[] columns = new String[]{"Module", "Coverage", "Covered Instructions", "Missed Instructions", "Total Instructions"};
        TreeColumn[] columns2 = viewer.getTree().getColumns();
        int i = 0;
        while (i < columns2.length) {
            columns2[i].setText(columns[i]);
            ++i;
        }
        this.restoreColumnWidth(viewer);
        viewer.setContentProvider((IContentProvider)provider);
        return viewer;
    }

    public void restoreColumnWidth(TreeViewer viewer) {
        TreeColumn[] columns = viewer.getTree().getColumns();
        int i = 0;
        while (i < DEFAULT_COLUMNWIDTH.length) {
            columns[i].setWidth(DEFAULT_COLUMNWIDTH[i]);
            ++i;
        }
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.counterPanel = new STSCounterPanel(composite);
        this.counterPanel.setLayoutData(new GridData(768));
        this.progressBar = new STSProgressBar(composite);
        this.progressBar.setLayoutData(new GridData(768));
        return composite;
    }

    private void createTestViewers(Composite parent) {
        this.viewerbook = new PageBook(parent, 0);
        this.treeViewer = new TreeViewer((Composite)this.viewerbook, 516);
        this.treeViewer.setUseHashlookup(true);
        STSTestSuiteModel model = new STSTestSuiteModel();
        model.addListener(new STSExecutionListener(){

            @Override
            public void testExecuted() {
                STSTestRunnerView.this.treeViewer.getControl().getDisplay().syncExec(() -> {
                    STSTestRunnerView.this.refreshCounters();
                    STSTestRunnerView.this.treeViewer.refresh();
                });
            }
        });
        this.provider = new STSTestSuiteProvider(model);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        Menu menu = new Menu(this.treeViewer.getControl());
        MenuItem item1 = new MenuItem(menu, 8);
        item1.setText("Stop");
        item1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TreeSelection selec = (TreeSelection)STSTestRunnerView.this.treeViewer.getSelection();
                if (!selec.isEmpty()) {
                    selec.getFirstElement();
                    STSTestRunnerView.this.provider.getModel().interrupt();
                }
            }
        });
        this.treeViewer.getControl().setMenu(menu);
        this.viewerbook.showPage((Control)this.treeViewer.getTree());
    }

    @Focus
    void setFocus() {
        this.sashForm.setFocus();
    }

    public void currentTest(Resource test) {
        this.treeViewer.setInput((Object)test);
        this.refreshCounters();
    }

    private void refreshCounters() {
        boolean stopped;
        boolean hasErrorsOrFailures;
        int assumptionFailureCount;
        int failureCount;
        int errorCount;
        int totalCount;
        int ignoredCount;
        int startedCount;
        STSTestSuiteModel model = this.provider.getModel();
        if (model != null) {
            startedCount = model.getStartedCount();
            ignoredCount = model.getIgnoredCount();
            totalCount = model.getTotalCount();
            errorCount = model.getErrorCount();
            failureCount = model.getFailureCount();
            assumptionFailureCount = model.getAssumptionFailureCount();
            hasErrorsOrFailures = errorCount + failureCount > 0;
            stopped = model.isStopped();
        } else {
            startedCount = 0;
            ignoredCount = 0;
            totalCount = 0;
            errorCount = 0;
            failureCount = 0;
            assumptionFailureCount = 0;
            hasErrorsOrFailures = false;
            stopped = false;
        }
        this.counterPanel.setTotal(totalCount);
        this.counterPanel.setRunValue(startedCount, ignoredCount, assumptionFailureCount);
        this.counterPanel.setIgnoredValue(ignoredCount);
        this.counterPanel.setErrorValue(errorCount);
        this.counterPanel.setFailureValue(failureCount);
        int ticksDone = startedCount == 0 ? 0 : (startedCount == totalCount && model.isStopped() ? totalCount : startedCount - 1);
        this.progressBar.reset(hasErrorsOrFailures, stopped, ticksDone, totalCount);
    }

    public void execute() {
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                STSTestRunnerView.this.provider.getModel().execute();
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.provider.dispose();
    }
}

