/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;

public class STSSuiteSorterRule
implements SorterRule,
Sorter {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Sorter getSorter(ReadGraph graph, Object content) throws DatabaseException {
        return this;
    }

    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        try {
            STSTestComparator stc = new STSTestComparator();
            stc.graph = graph;
            Collections.sort(nodes, stc);
        }
        catch (RuntimeDatabaseException e) {
            if (e.getCause() != null && e.getCause() instanceof DatabaseException) {
                throw (DatabaseException)e.getCause();
            }
            throw e;
        }
    }

    static class STSTestComparator
    implements Comparator<NodeContext> {
        ReadGraph graph;

        STSTestComparator() {
        }

        @Override
        public int compare(NodeContext nc1, NodeContext nc2) {
            Pair test2;
            Pair test1;
            block5: {
                block4: {
                    Resource r1 = (Resource)nc1.getConstant(BuiltinKeys.INPUT);
                    Resource r2 = (Resource)nc2.getConstant(BuiltinKeys.INPUT);
                    try {
                        test1 = (Pair)this.graph.sync((ReadInterface)new STSTestQuery(r1));
                        test2 = (Pair)this.graph.sync((ReadInterface)new STSTestQuery(r2));
                        if ((Integer)test1.first >= (Integer)test2.first) break block4;
                        return -1;
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeDatabaseException((Throwable)e);
                    }
                }
                if ((Integer)test1.first <= (Integer)test2.first) break block5;
                return 1;
            }
            return AlphanumComparator.COMPARATOR.compare(test1.second, test2.second);
        }
    }

    static class STSTestQuery
    extends ResourceRead<Pair<Integer, String>> {
        public STSTestQuery(Resource resource) {
            super(resource);
        }

        public Pair<Integer, String> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
            String name = (String)graph.getRelatedValue2(this.resource, L0.HasName, (Binding)Bindings.STRING);
            Integer priority = (Integer)graph.getRelatedValue2(this.resource, TESTS.STSTest_executionPriority, (Binding)Bindings.INTEGER);
            return new Pair((Object)priority, (Object)name);
        }
    }
}

