/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;

/**
 * This contributor tries to find all the models related to a project and will
 * only be invoked when the input is a database resource.
 */
public class ProjectModels extends ViewpointContributor<Resource> {

    @Override
    public Collection<?> getContribution(ReadGraph graph, Resource project)
    throws DatabaseException {

        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        Layer0 L0 = Layer0.getInstance(graph);
        for(Resource r : graph.syncRequest(new ObjectsWithType(project, L0.ConsistsOf, SimulationResource.getInstance(graph).Model))) {
            try {
                result.add(graph.adapt(r, AbstractNode.class));
            } catch(DatabaseException e) {
                e.printStackTrace();
            }
        }
        return result;

    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

}
