/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.Collection;

import org.simantics.browsing.ui.common.EvaluatorImpl;
import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.extension.EvaluatorFactory;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.utils.ReflectionUtils;

public abstract class PartialEvaluatorFactory<T> implements EvaluatorFactory {

	final private Class<?> clazz;

    public PartialEvaluatorFactory() {
    	clazz = ReflectionUtils.getSingleParameterType(getClass());
    }
    
	@Override
	public Evaluator create(Collection<String> browseContexts) {
		EvaluatorImpl result = new EvaluatorImpl();
		double preference = getPreference();
		{
			ComparableContextFactory factory = createComparableFactory();
			if(factory != null)
				result.addComparator(factory, preference);
		}
		{
			LabelDecoratorFactory factory = createLabelDecoratorFactory();
			if(factory != null)
				result.addLabelDecorator(factory, preference);
		}
		{
			ImagerFactory factory = createImagerFactory();
			if(factory != null)
				result.addImager(factory, preference);
		}
		return result;
	}
	
	protected double getPreference() {
		return 1.0;
	}
	
	protected ComparableContextFactory createComparableFactory() {
		return null;
	}
	
	protected LabelDecoratorFactory createLabelDecoratorFactory() {
		return null;
	}	
	
	protected ImagerFactory createImagerFactory() {
		return null;
	}	

	@Override
	public Class<?> getClazz() {
		return clazz;
	}

}
