package org.simantics.scenegraph.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.SGMouseEvent;
import org.simantics.scenegraph.g2d.events.SGMouseWheelEvent;
import org.simantics.scenegraph.swing.ComponentNode.ComponentContainer;

public class JComponentUtils {

    private static int getAbsoluteX(Component c, int init) {
    	if(c instanceof ComponentContainer) return init;
    	else return getAbsoluteX(c.getParent(), init+c.getX());
    }
    
    private static int getAbsoluteY(Component c, int init) {
    	if(c instanceof ComponentContainer) return init;
    	else return getAbsoluteY(c.getParent(), init+c.getY());
    }

    private static Point transform(int eventX, int eventY, JComponentSG comp, INode node) {
    	
    	if(node == null) return null;
    	
		G2DSceneGraph sg = (G2DSceneGraph)node.getRootNode();
		AWTChassis chassis = (AWTChassis)(sg.getRootPane().getParent());
		
		int trX = getAbsoluteX(comp.getComponent(), 0);
		int trY = getAbsoluteY(comp.getComponent(), 0);
		
		AffineTransform ct = chassis.getCanvasContext().getDefaultHintContext().getHint(Hints.KEY_CANVAS_TRANSFORM);
		if(ct == null) return null;

		eventX += trX;
		eventX -= ct.getTranslateX();
		eventX /= ct.getScaleX();
		eventX -= trX;
		eventY += trY;
		eventY -= ct.getTranslateY();
		eventY /= ct.getScaleY();
		eventY -= trY;
		
		return new Point(eventX, eventY);
    	
    }
    
	public static boolean contains(int eventX, int eventY, JComponentSG comp, INode node) {
		
		Point transformed = transform(eventX, eventY, comp, node);

		if(transformed == null) return comp.containsTransformed(new Point(eventX, eventY));
		
		boolean result = comp.containsTransformed(transformed); 
		
//		System.err.println(result + " - contains(" + comp.getClass().getCanonicalName() + ") ? (" + origX + "," + origY + ")=>(" + eventX + "," + eventY + ")");
		
		return result; 
		
	}
	
    public static AWTEvent relocate(AWTEvent e, JComponentSG comp, INode node) {

		if(node == null) return e;

    	if(!(e instanceof MouseEvent)) return e; // Only for mouse events
    	MouseEvent me = (MouseEvent)e;

		Point transformed = transform(me.getX(), me.getY(), comp, node);
		if(transformed == null) return e;

        if(me.getID() == MouseWheelEvent.MOUSE_WHEEL) {
            return new SGMouseWheelEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), transformed.x, transformed.y, me.getClickCount(), me.isPopupTrigger(), ((MouseWheelEvent)me).getScrollType(), ((MouseWheelEvent)me).getScrollAmount(), ((MouseWheelEvent)me).getWheelRotation(), me);
        } else {
            return new SGMouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), transformed.x, transformed.y, me.getClickCount(), me.isPopupTrigger(), me.getButton(), me);
        }
        
    }	
	
}
