/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.mapping.IContextualModification;

public class BinaryPredicateInstruction extends Instruction2 {
	
	IBinaryPredicate predicate;
	
	public BinaryPredicateInstruction(int variable0, int variable1,
			IBinaryPredicate predicate) {
		super(variable0, variable1);
		this.predicate = predicate;
	}

	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
//		ITask task = ThreadLogger.getInstance().begin("g");
		if(predicate.has(g, (Resource)bindings[variable0], (Resource)bindings[variable1])) {
//			task.finish();
			return null;
		}
		else {
//			task.finish();
			return IInstruction.FAILURE;
		}
	}
	
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) {
		return IInstruction.FAILURE;
	}
	
	@Override
	public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
//		ITask task = ThreadLogger.getInstance().begin("g");
		if(!predicate.has(g, r0, r1)) {
//			task.finish();		
			return new IContextualModification() {

				@Override
				public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
					Resource r0 = (Resource)bindings[variable0];
					Resource r1 = (Resource)bindings[variable1];
					if(DEBUG_MODI)
					    System.out.println("claim(" +
					            NameUtils.getSafeName(g, r0) + ", " +
					            predicate.toString(g) + ", " +
					            NameUtils.getSafeName(g, r1) + ")"
					            );
					if(!DISABLE_MODI)
						predicate.add(g, r0, r1);
				}
			
			};
		}
//		task.finish();
		return null;
	}

	@Override
	public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
//		ITask task = ThreadLogger.getInstance().begin("g");
		if(DEBUG)
    		System.out.println("@ claim(" + NameUtils.getSafeName(g, r0) + 
    		        ", " + predicate.toString(g) + ", " +  NameUtils.getSafeName(g, r1) + ")");
		if(DEBUG_MODI)
            System.out.println("claim(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    predicate.toString(g) + ", " +
                    NameUtils.getSafeName(g, r1) + ")"
                    );
		if(!DISABLE_MODI)
			predicate.add(g, r0, r1);
//		task.finish();
	}
	
	@Override
	public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		if(predicate.has(g, r0, r1))
			return new IContextualModification() {

				@Override
				public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
					Resource r0 = (Resource)bindings[variable0];
					Resource r1 = (Resource)bindings[variable1];
					if(DEBUG_MODI)
                        System.out.println("deny(" +
                                NameUtils.getSafeName(g, r0) + ", " +
                                predicate.toString(g) + ", " +
                                NameUtils.getSafeName(g, r1) + ")"
                                );
					if(!DISABLE_MODI)
						predicate.remove(g, r0, r1);
				}
			
			};
		return null;
	}

	@Override
	public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {	    
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		if(DEBUG_MODI)
            System.out.println("deny(" +
                    NameUtils.getSafeName(g, r0) + ", " +
                    predicate.toString(g) + ", " +
                    NameUtils.getSafeName(g, r1) + ")"
                    );
		if(!DISABLE_MODI)
			predicate.remove(g, r0, r1);
	}
	
	@Override
	public void toString(StringBuilder b, int indent) {
		b.append('(');
		b.append(variable0);
		b.append(',');
		b.append(variable1);
		b.append(')');
	}
}
