/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public interface IConstraint {
	/**
	 * 
	 * @param bound
	 * @return 0 if not applicable
	 *        >0 if applicable, bigger is better
	 */
	int isApplicable(ImmutableSet<Resource> bound);
	ImmutableSet<Resource> binds();
	IInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds, 
			ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException;
}
