/*******************************************************************************
 * Copyright (c) 2007- VTT Technical Research Centre of Finland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping;


import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

public class MappingResource {
    
    public final Resource BinaryPredicateConstraint;
    public final Resource ClaimRule;
    public final Resource CompositeRule;
    public final Resource Constraint;
    public final Resource ConstraintConjunction;
    public final Resource ConstraintDisjunction;
    public final Resource ConstraintGroup;
    public final Resource DenyRule;
    public final Resource Domain;
    public final Resource ExistsConstraint;
    public final Resource HasBinaryPredicate;
    public final Resource HasChildRule;
    public final Resource HasCondition;
    public final Resource HasConstraint;
    public final Resource HasDomain;
    public final Resource HasElseRule;
    public final Resource HasMappingDescription;
    public final Resource HasParameter;
    public final Resource HasParameterRelation;
    public final Resource HasPredicate;
    public final Resource HasPredicateSuperrelation;
    public final Resource HasPrimaryConstraintGroup;
    public final Resource HasResource;
    public final Resource HasRule;
    public final Resource HasSubject;
    public final Resource HasThenRule;
    public final Resource HasUnaryPredicate;
    public final Resource IfRule;
    public final Resource Mapping;
    public final Resource MappingDescription;
    public final Resource MappingDomain;
    public final Resource MappingParameter;
    public final Resource MappingRule;
    public final Resource ResourceVariable;
    public final Resource Rule;
    public final Resource SourceDomain;
    public final Resource StaticDomain;
    public final Resource TargetDomain;
    public final Resource TripletConstraint;
    public final Resource UnaryPredicateConstraint;
    public final Resource UnlessRule;
    
    public static class URIs {
        public static final String BinaryPredicateConstraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/BinaryPredicateConstraint";
        public static final String ClaimRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/ClaimRule";
        public static final String CompositeRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/CompositeRule";
        public static final String Constraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/Constraint";
        public static final String ConstraintConjunction = "http://Projects/TypeSystemProject/MappingOntology/Constraints/ConstraintConjunction";
        public static final String ConstraintDisjunction = "http://Projects/TypeSystemProject/MappingOntology/Constraints/ConstraintDisjunction";
        public static final String ConstraintGroup = "http://Projects/TypeSystemProject/MappingOntology/Mappings/ConstraintGroup";
        public static final String DenyRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/DenyRule";
        public static final String Domain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/Domain";
        public static final String ExistsConstraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/ExistsConstraint";
        public static final String HasBinaryPredicate = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasBinaryPredicate";
        public static final String HasChildRule = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasChildRule";
        public static final String HasCondition = "http://Projects/TypeSystemProject/MappingOntology/Rules/HasCondition";
        public static final String HasConstraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasConstraint";
        public static final String HasDomain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasDomain";
        public static final String HasElseRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/HasElseRule";
        public static final String HasMappingDescription = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasMappingDescription";
        public static final String HasParameter = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasParameter";
        public static final String HasParameterRelation = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasParameterRelation";
        public static final String HasPredicate = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasPredicate";
        public static final String HasPredicateSuperrelation = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasPredicateSuperrelation";
        public static final String HasPrimaryConstraintGroup = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasPrimaryConstraintGroup";
        public static final String HasResource = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasResource";
        public static final String HasRule = "http://Projects/TypeSystemProject/MappingOntology/Mappings/HasRule";
        public static final String HasSubject = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasSubject";
        public static final String HasThenRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/HasThenRule";
        public static final String HasUnaryPredicate = "http://Projects/TypeSystemProject/MappingOntology/Constraints/HasUnaryPredicate";
        public static final String IfRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/IfRule";
        public static final String Mapping = "http://Projects/TypeSystemProject/MappingOntology/Mappings/Mapping";
        public static final String MappingDescription = "http://Projects/TypeSystemProject/MappingOntology/Mappings/MappingDescription";
        public static final String MappingDomain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/MappingDomain";
        public static final String MappingParameter = "http://Projects/TypeSystemProject/MappingOntology/Mappings/MappingParameter";
        public static final String MappingRule = "http://Projects/TypeSystemProject/MappingOntology/Mappings/MappingRule";
        public static final String ResourceVariable = "http://Projects/TypeSystemProject/MappingOntology/Constraints/ResourceVariable";
        public static final String Rule = "http://Projects/TypeSystemProject/MappingOntology/Rules/Rule";
        public static final String SourceDomain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/SourceDomain";
        public static final String StaticDomain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/StaticDomain";
        public static final String TargetDomain = "http://Projects/TypeSystemProject/MappingOntology/Mappings/TargetDomain";
        public static final String TripletConstraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/TripletConstraint";
        public static final String UnaryPredicateConstraint = "http://Projects/TypeSystemProject/MappingOntology/Constraints/UnaryPredicateConstraint";
        public static final String UnlessRule = "http://Projects/TypeSystemProject/MappingOntology/Rules/UnlessRule";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public MappingResource(ReadGraph graph) {
        BinaryPredicateConstraint = getResourceOrNull(graph, URIs.BinaryPredicateConstraint);
        ClaimRule = getResourceOrNull(graph, URIs.ClaimRule);
        CompositeRule = getResourceOrNull(graph, URIs.CompositeRule);
        Constraint = getResourceOrNull(graph, URIs.Constraint);
        ConstraintConjunction = getResourceOrNull(graph, URIs.ConstraintConjunction);
        ConstraintDisjunction = getResourceOrNull(graph, URIs.ConstraintDisjunction);
        ConstraintGroup = getResourceOrNull(graph, URIs.ConstraintGroup);
        DenyRule = getResourceOrNull(graph, URIs.DenyRule);
        Domain = getResourceOrNull(graph, URIs.Domain);
        ExistsConstraint = getResourceOrNull(graph, URIs.ExistsConstraint);
        HasBinaryPredicate = getResourceOrNull(graph, URIs.HasBinaryPredicate);
        HasChildRule = getResourceOrNull(graph, URIs.HasChildRule);
        HasCondition = getResourceOrNull(graph, URIs.HasCondition);
        HasConstraint = getResourceOrNull(graph, URIs.HasConstraint);
        HasDomain = getResourceOrNull(graph, URIs.HasDomain);
        HasElseRule = getResourceOrNull(graph, URIs.HasElseRule);
        HasMappingDescription = getResourceOrNull(graph, URIs.HasMappingDescription);
        HasParameter = getResourceOrNull(graph, URIs.HasParameter);
        HasParameterRelation = getResourceOrNull(graph, URIs.HasParameterRelation);
        HasPredicate = getResourceOrNull(graph, URIs.HasPredicate);
        HasPredicateSuperrelation = getResourceOrNull(graph, URIs.HasPredicateSuperrelation);
        HasPrimaryConstraintGroup = getResourceOrNull(graph, URIs.HasPrimaryConstraintGroup);
        HasResource = getResourceOrNull(graph, URIs.HasResource);
        HasRule = getResourceOrNull(graph, URIs.HasRule);
        HasSubject = getResourceOrNull(graph, URIs.HasSubject);
        HasThenRule = getResourceOrNull(graph, URIs.HasThenRule);
        HasUnaryPredicate = getResourceOrNull(graph, URIs.HasUnaryPredicate);
        IfRule = getResourceOrNull(graph, URIs.IfRule);
        Mapping = getResourceOrNull(graph, URIs.Mapping);
        MappingDescription = getResourceOrNull(graph, URIs.MappingDescription);
        MappingDomain = getResourceOrNull(graph, URIs.MappingDomain);
        MappingParameter = getResourceOrNull(graph, URIs.MappingParameter);
        MappingRule = getResourceOrNull(graph, URIs.MappingRule);
        ResourceVariable = getResourceOrNull(graph, URIs.ResourceVariable);
        Rule = getResourceOrNull(graph, URIs.Rule);
        SourceDomain = getResourceOrNull(graph, URIs.SourceDomain);
        StaticDomain = getResourceOrNull(graph, URIs.StaticDomain);
        TargetDomain = getResourceOrNull(graph, URIs.TargetDomain);
        TripletConstraint = getResourceOrNull(graph, URIs.TripletConstraint);
        UnaryPredicateConstraint = getResourceOrNull(graph, URIs.UnaryPredicateConstraint);
        UnlessRule = getResourceOrNull(graph, URIs.UnlessRule);
    }
    
    public static MappingResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        MappingResource ret = session.getService(MappingResource.class);
        if(ret == null) {
            ret = new MappingResource(graph);
            session.registerService(MappingResource.class, ret);
        }
        return ret;
    }
    
    public static MappingResource getInstance(Session session) throws DatabaseException {
        MappingResource ret = session.getService(MappingResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<MappingResource>() {
                public MappingResource perform(ReadGraph graph) throws DatabaseException {
                    return new MappingResource(graph);
                }
            });
            session.registerService(MappingResource.class, ret);
        }
        return ret;
    }
    
}

