/*******************************************************************************
 * Copyright (c) 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.server.environment.windows;

/**
 * The possible return values of Win32 API call MsiQueryProductState enumerated.
 * 
 * @author Tuukka Lehtonen
 */
public enum ProductState {

    /**
     * An invalid parameter was passed to the function.
     */
    INVALIDARG(-2),

    /**
     * The product is not advertised or installed.
     */
    UNKNOWN(-1),

    /**
     * Indicates invocation of {@link Msi#MsiQueryProductState(String)} failed.
     */
    FAILED(0),

    /**
     * The product is advertised but not installed.
     */
    ADVERTISED(1),

    /**
     * The product is installed for a different user.
     */
    ABSENT(2),

    /**
     * The product is installed for a different user.
     */
    DEFAULT(5);

    int code;

    ProductState(int code) {
        this.code = code;
    }

    public static ProductState of(int code) {
        switch (code) {
            case -2: return INVALIDARG;
            case -1: return UNKNOWN;
            case 0: return FAILED;
            case 1: return ADVERTISED;
            case 2: return ABSENT;
            case 5: return DEFAULT;
            default: throw new IllegalArgumentException("unrecognized product install state return code: " + code);
        }
    }

    @Override
    public String toString() {
        return name() + "(" + code + ")";
    }

}
