/*******************************************************************************
 * Copyright (c) 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.server.environment.windows;

/**
 * @author Tuukka Lehtonen
 */
public final class ProductCodes {

//    // Visual C++ 2008 runtime files
//
//    // Visual C++ 2008 Redistributable Package (x86)
//    // {FF66E9F6-83E7-3A3E-AF14-8DE9A809A6A4}
//    public static final Product VISUAL_CPP_2008_REDIST_X86      = new Product("{FF66E9F6-83E7-3A3E-AF14-8DE9A809A6A4}",
//                                                                        "Visual C++ 2008 Redistributable Package (x86)");
//
//    // Visual C++ 2008 Redistributable Package (x64)
//    // {350AA351-21FA-3270-8B7A-835434E766AD}
//    public static final Product VISUAL_CPP_2008_REDIST_X64      = new Product("{350AA351-21FA-3270-8B7A-835434E766AD}",
//                                                                        "Visual C++ 2008 Redistributable Package (x64)");
//
//    // Visual C++ 2008 Redistributable Package (ia64)
//    // {2B547B43-DB50-3139-9EBE-37D419E0F5FA}
//    public static final Product VISUAL_CPP_2008_REDIST_IA64     = new Product("{2B547B43-DB50-3139-9EBE-37D419E0F5FA}",
//                                                                        "Visual C++ 2008 Redistributable Package (ia64)");

    // Visual C++ 2008 SP1 runtime files

    // THIS ONE IS CURRENTLY USED BY ProCore

    // Visual C++ 2008 SP1 Redistributable Package (x86)
    // {9A25302D-30C0-39D9-BD6F-21E6EC160475}
    // Date Published: 9/16/2008
    // 9.0.30729.17
    // http://www.microsoft.com/downloads/en/details.aspx?familyid=A5C84275-3B97-4AB7-A40D-3802B2AF5FC2&displaylang=en
    public static final Product VISUAL_CPP_2008_SP1_REDIST_X86  = new Product("{9A25302D-30C0-39D9-BD6F-21E6EC160475}",
                                                                        "Visual C++ 2008 SP1 Redistributable Package (x86) (v9.0.30729.17)");

    // Visual C++ 2008 SP1 Redistributable Package (x86) KB2467174
    // {86CE85E6-DBAC-3FFD-B977-E4B79F83C909}
    // Date Published: 4/12/2011
    // 9.0.30729.5570
    // http://support.microsoft.com/kb/2467174
    // http://www.microsoft.com/downloads/en/details.aspx?familyid=05ce856d-8128-408b-96fa-5e1f57b097d8&displaylang=en
    public static final Product VISUAL_CPP_2008_SP1_REDIST_X86_KB2467174  = new Product("{86CE85E6-DBAC-3FFD-B977-E4B79F83C909}",
                                                                        "Microsoft Visual C++ 2008 Redistributable - KB2467174 - x86 9.0.30729.5570");

    // Visual C++ 2008 SP1 Redistributable Package (x64)
    // {8220EEFE-38CD-377E-8595-13398D740ACE}
    // Date Published: 8/9/2008
    // 9.0.30729.17
    // http://www.microsoft.com/downloads/en/details.aspx?familyid=BA9257CA-337F-4B40-8C14-157CFDFFEE4E&displaylang=en
    public static final Product VISUAL_CPP_2008_SP1_REDIST_X64  = new Product("{8220EEFE-38CD-377E-8595-13398D740ACE}",
                                                                        "Visual C++ 2008 SP1 Redistributable Package (x64) (v9.0.30729.17)");

    // Visual C++ 2008 SP1 Redistributable Package (x64) KB2467174
    // {8338783A-0968-3B85-AFC7-BAAE0A63DC50}
    // Date Published: 4/12/2011
    // 9.0.30729.5570
    // http://support.microsoft.com/kb/2467174
    // http://www.microsoft.com/downloads/en/details.aspx?familyid=05ce856d-8128-408b-96fa-5e1f57b097d8&displaylang=en
    public static final Product VISUAL_CPP_2008_SP1_REDIST_X64_KB2467174 = new Product("{8338783A-0968-3B85-AFC7-BAAE0A63DC50}",
                                                                                 "Microsoft Visual C++ 2008 Redistributable - KB2467174 - x64 9.0.30729.5570");

//    // Visual C++ 2008 SP1 Redistributable Package (ia64)
//    // {5827ECE1-AEB0-328E-B813-6FC68622C1F9}
//    // Date Published: 8/9/2008
//    // 9.0.30729.17
//    // http://www.microsoft.com/downloads/en/details.aspx?FamilyID=DCC211E6-AB82-41D6-8DEC-C79937393FE8&displaylang=en
//    public static final Product VISUAL_CPP_2008_SP1_REDIST_IA64 = new Product("{5827ECE1-AEB0-328E-B813-6FC68622C1F9}",
//                                                                        "Visual C++ 2008 SP1 Redistributable Package (ia64) (v9.0.30729.17)");

    // Visual C++ 2010 runtime files

    // Visual C++ 2010 Redistributable Package (x86)
    // {196BB40D-1578-3D01-B289-BEFC77A11A1E}
    public static final Product VISUAL_CPP_2010_REDIST_X86      = new Product("{196BB40D-1578-3D01-B289-BEFC77A11A1E}",
                                                                        "Visual C++ 2010 Redistributable Package (x86)");

    // Visual C++ 2010 Redistributable Package (x64)
    // {DA5E371C-6333-3D8A-93A4-6FD5B20BCC6E}
    public static final Product VISUAL_CPP_2010_REDIST_X64      = new Product("{DA5E371C-6333-3D8A-93A4-6FD5B20BCC6E}",
                                                                        "Visual C++ 2010 Redistributable Package (x64)");

    // Visual C++ 2010 Redistributable Package (ia64)
    // {C1A35166-4301-38E9-BA67-02823AD72A1B}
    public static final Product VISUAL_CPP_2010_REDIST_IA64     = new Product("{C1A35166-4301-38E9-BA67-02823AD72A1B}",
                                                                        "Visual C++ 2010 Redistributable Package (ia64)");

    // Visual C++ 2010 SP1 runtime files

    // Visual C++ 2010 SP1 Redistributable Package (x86)
    // {F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}
    public static final Product VISUAL_CPP_2010_SP1_REDIST_X86           = new Product("{F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}",
                                                                                 "Visual C++ 2010 SP1 Redistributable Package (x86)");

    // Visual C++ 2010 SP1 Redistributable Package (x64)
    // {1D8E6291-B0D5-35EC-8441-6616F567A0F7}
    public static final Product VISUAL_CPP_2010_SP1_REDIST_X64           = new Product("{1D8E6291-B0D5-35EC-8441-6616F567A0F7}",
                                                                                 "Visual C++ 2010 SP1 Redistributable Package (x64)");

    // Visual C++ 2010 SP1 Redistributable Package (ia64)
    // {88C73C1C-2DE5-3B01-AFB8-B46EF4AB41CD}
    public static final Product VISUAL_CPP_2010_SP1_REDIST_IA64          = new Product("{88C73C1C-2DE5-3B01-AFB8-B46EF4AB41CD}",
                                                                                 "Visual C++ 2010 SP1 Redistributable Package (ia64)");

}
