/*******************************************************************************
 * Copyright (c) 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.server.environment;


/**
 * @author Tuukka Lehtonen
 */
public final class ExecutionEnvironment {

    public final OSType os;
    public final ARCHType arch;

    private ExecutionEnvironment(OSType os, ARCHType arch) {
        this.os = os;
        this.arch = arch;
    }

    public static ExecutionEnvironment calculate() {
        return new ExecutionEnvironment(calculateOS(), calculateArch());
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch", "");
        osArch = osArch.toLowerCase();
        if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86"))
            return ARCHType.X86;
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64"))
            return ARCHType.X86_64;
        if (osArch.equals("ppc"))
            return ARCHType.PPC;
        if (osArch.startsWith("ppc"))
            return ARCHType.PPC_64;
        if (osArch.startsWith("sparc"))
            return ARCHType.SPARC;
        return ARCHType.UNKNOWN;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name", "");
        osName = osName.toLowerCase();
        if (osName.startsWith("mac os x"))
            return OSType.APPLE;
        if (osName.startsWith("windows"))
            return OSType.WINDOWS;
        if (osName.startsWith("linux"))
            return OSType.LINUX;
        if (osName.startsWith("sun"))
            return OSType.SUN;
        return OSType.UNKNOWN;
    }

}
