/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.simantics.audit.Activator;
import org.simantics.audit.AuditLoggingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogging.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String timestamp = "timestamp";

    public static String register(String id) throws AuditLoggingException {
        try {
            String entryRoot = String.valueOf(id) + "_" + UUID.randomUUID().toString();
            Files.createDirectories(AuditLogging.getEntryRoot(entryRoot), new FileAttribute[0]);
            return entryRoot;
        }
        catch (Exception e) {
            throw new AuditLoggingException("Could not register service with id " + id, e);
        }
    }

    public static List<String> getLogEventsDays(String uuid, String level, int days) throws AuditLoggingException {
        LocalDate endDate = LocalDate.now().plusDays(1L);
        LocalDate startDate = endDate.minusDays(days);
        return AuditLogging.getLogEvents(uuid, level, startDate, endDate);
    }

    public static List<String> getLogEvents(String uuid, String level, String startDate, String endDate) throws AuditLoggingException {
        try {
            LocalDate localStartDate = LocalDate.parse(startDate);
            LocalDate localEndDate = LocalDate.parse(endDate).plusDays(1L);
            return AuditLogging.getLogEvents(uuid, level, localStartDate, localEndDate);
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }

    private static List<String> getLogEvents(String uuid, String level, LocalDate localStartDate, LocalDate localEndDate) throws AuditLoggingException {
        Path entryRoot = AuditLogging.getEntryRoot(uuid);
        try {
            ArrayList<String> allLines = new ArrayList<String>();
            while (localStartDate.isBefore(localEndDate)) {
                String fileName = AuditLogging.resolveLogFileName(uuid, Level.valueOf(level.toUpperCase()), localStartDate);
                try {
                    try {
                        Path fileToRead = entryRoot.resolve(fileName);
                        if (Files.exists(fileToRead, new LinkOption[0])) {
                            List<String> lines = Files.readAllLines(fileToRead);
                            allLines.addAll(lines);
                        } else {
                            LOGGER.info("No logging events for " + fileName);
                        }
                    }
                    catch (FileSystemException e) {
                        LOGGER.error("Could not read file {}", (Object)fileName, (Object)e);
                        localStartDate = localStartDate.plusDays(1L);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    localStartDate = localStartDate.plusDays(1L);
                    throw throwable;
                }
                localStartDate = localStartDate.plusDays(1L);
            }
            return allLines;
        }
        catch (Exception e) {
            throw new AuditLoggingException(e);
        }
    }

    public static Path getEntryRoot(String uuid) {
        return Activator.getLogLocation().resolve(uuid);
    }

    public static Path getLogFile(String uuid, Level level) {
        Path root = AuditLogging.getEntryRoot(uuid);
        String fileName = AuditLogging.resolveLogFileName(uuid, level, LocalDate.now());
        return root.resolve(fileName);
    }

    private static String resolveLogFileName(String uuid, Level level, LocalDate date) {
        return String.valueOf(date.toString()) + "_" + uuid + "." + level.toString().toLowerCase();
    }

    public static void log(String uuid, Map<String, Object> json) throws AuditLoggingException {
        AuditLogging.write(uuid, Level.INFO, json);
    }

    public static void error(String uuid, Map<String, Object> json) throws AuditLoggingException {
        AuditLogging.write(uuid, Level.ERROR, json);
    }

    public static void trace(String uuid, Map<String, Object> json) throws AuditLoggingException {
        AuditLogging.write(uuid, Level.TRACE, json);
    }

    private static void write(String uuid, Level level, Map<String, Object> json) throws AuditLoggingException {
        Map<String, Object> wrappedAuditEvent = AuditLogging.wrapAndAddAuditMetadata(uuid, level, json);
        try {
            String jsonLine = mapper.writeValueAsString(wrappedAuditEvent);
            Path logFile = AuditLogging.getLogFile(uuid, level);
            if (!Files.exists(logFile, new LinkOption[0])) {
                Files.createFile(logFile, new FileAttribute[0]);
            }
            String lineWithNewline = String.valueOf(jsonLine) + "\n";
            Files.write(logFile, lineWithNewline.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (JsonProcessingException e) {
            throw new AuditLoggingException("Could not serialize input", e);
        }
        catch (IOException e) {
            throw new AuditLoggingException("Could not write line to log", e);
        }
    }

    private static Map<String, Object> wrapAndAddAuditMetadata(String uuid, Level level, Map<String, Object> original) {
        HashMap<String, Object> wrapped = new HashMap<String, Object>();
        long newValue = System.currentTimeMillis();
        Object possibleExisting = wrapped.put(timestamp, newValue);
        if (possibleExisting != null) {
            LOGGER.warn("Replacing existing value {} for key {} - new value is {}", new Object[]{possibleExisting, timestamp, newValue});
        }
        if ((possibleExisting = wrapped.put("uuid", uuid)) != null) {
            LOGGER.warn("Replacing existing value {} for key {} - new value is {}", new Object[]{possibleExisting, "uuid", uuid});
        }
        if ((possibleExisting = wrapped.put("level", level.toString())) != null) {
            LOGGER.warn("Replacing existing value {} for key {} - new value is {}", new Object[]{possibleExisting, "level", level.toString()});
        }
        wrapped.put("original", original);
        return wrapped;
    }

    public static enum Level {
        INFO,
        ERROR,
        TRACE;

    }
}

