/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.vtk.shape.IvtkVisualObject;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkLineSource;
import vtk.vtkLinearTransform;
import vtk.vtkMapper;
import vtk.vtkMatrix4x4;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class axisActor
extends vtkAssembly
implements IvtkVisualObject {
    private vtkRenderer ren;
    private Vector3d axisDir = new Vector3d(1.0, 0.0, 0.0);
    private vtkTextActor tactor;
    private vtkActor tubeActor;
    private vtkActor coneActor;
    private boolean rendered = false;
    double[] mat = new double[16];
    Matrix4d m = new Matrix4d();
    Point3d p = new Point3d();

    public axisActor(vtkRenderer _ren, String label) {
        this.ren = _ren;
        this.createAxis(label);
    }

    public axisActor(vtkRenderer _ren, String label, Vector3d dir) {
        this.ren = _ren;
        this.axisDir = dir;
        this.createAxis(label);
    }

    public void createAxis(String label) {
        vtkLineSource line = new vtkLineSource();
        line.SetPoint1(0.0, 0.0, 0.0);
        line.SetPoint2(this.axisDir.x, this.axisDir.y, this.axisDir.z);
        this.tactor = new vtkTextActor();
        this.tactor.SetInput(label);
        this.tactor.SetTextScaleModeToNone();
        this.tactor.GetTextProperty().SetColor(0.0, 0.0, 0.0);
        this.tactor.GetTextProperty().ShadowOff();
        this.tactor.GetTextProperty().ItalicOff();
        this.tactor.GetTextProperty().BoldOff();
        this.tactor.GetTextProperty().Delete();
        this.tactor.SetMaximumLineHeight(0.25);
        this.tactor.SetPickable(0);
        vtkTubeFilter tube = new vtkTubeFilter();
        tube.SetInputData((vtkDataObject)line.GetOutput());
        tube.SetRadius(0.05 * this.axisDir.length());
        tube.SetNumberOfSides(8);
        vtkPolyDataMapper tubeMapper = new vtkPolyDataMapper();
        tubeMapper.SetInputData(tube.GetOutput());
        this.tubeActor = new vtkActor();
        this.tubeActor.SetMapper((vtkMapper)tubeMapper);
        this.tubeActor.PickableOff();
        int coneRes = 12;
        double coneScale = 0.3 * this.axisDir.length();
        vtkConeSource cone = new vtkConeSource();
        cone.SetResolution(coneRes);
        vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
        coneMapper.SetInputData(cone.GetOutput());
        this.coneActor = new vtkActor();
        this.coneActor.SetMapper((vtkMapper)coneMapper);
        this.coneActor.GetProperty().SetColor(1.0, 0.0, 0.0);
        this.coneActor.SetScale(coneScale, coneScale, coneScale);
        this.coneActor.SetPosition(this.axisDir.x, this.axisDir.y, this.axisDir.z);
        this.coneActor.SetPickable(0);
        AxisAngle4d aa = MathTools.createRotation((Vector3d)new Vector3d(1.0, 0.0, 0.0), (Vector3d)new Vector3d(this.axisDir));
        if (aa != null) {
            this.coneActor.RotateWXYZ(MathTools.radToDeg((double)aa.angle), aa.x, aa.y, aa.z);
        }
        this.AddPart((vtkProp3D)this.tubeActor);
        this.AddPart((vtkProp3D)this.coneActor);
        tube.GetOutput().Delete();
        cone.GetOutput().Delete();
        line.GetOutput().Delete();
        tubeMapper.Delete();
        tube.Delete();
        cone.Delete();
        line.Delete();
        coneMapper.Delete();
        this.coneActor.GetProperty().Delete();
    }

    @Override
    public void addToRenderer() {
        if (this.rendered) {
            return;
        }
        this.rendered = true;
        this.ren.AddActor2D((vtkProp)this.tactor);
        this.ren.AddActor((vtkProp)this);
    }

    @Override
    public void removeFromRenderer() {
        if (!this.rendered) {
            return;
        }
        this.rendered = false;
        this.ren.RemoveActor2D((vtkProp)this.tactor);
        this.ren.RemoveActor((vtkProp)this);
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    public void setAxesVisibility(boolean ison) {
        this.SetVisibility(ison ? 1 : 0);
        this.tactor.SetVisibility(ison ? 1 : 0);
    }

    public void setLabelVisibility(boolean ison) {
        this.tactor.SetVisibility(ison ? 1 : 0);
    }

    private void updateTextLoc() {
        this.tactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.GetMatrix(this.mat);
        MathTools.set((Matrix4d)this.m, (double[])this.mat);
        this.p.set(this.axisDir.x, this.axisDir.y, this.axisDir.z);
        this.m.transform(this.p);
        this.tactor.GetPositionCoordinate().SetValue(this.p.x, this.p.y, this.p.z);
        this.tactor.GetPositionCoordinate().Delete();
    }

    public void SetPickable(int id0) {
        super.SetPickable(id0);
        this.tubeActor.SetPickable(id0);
        this.coneActor.SetPickable(id0);
    }

    public void SetOrientation(double id0, double id1, double id2) {
        super.SetOrientation(id0, id1, id2);
        this.updateTextLoc();
    }

    public void RotateWXYZ(double id0, double id1, double id2, double id3) {
        super.RotateWXYZ(id0, id1, id2, id3);
        this.updateTextLoc();
    }

    public void SetPosition(double[] id0) {
        super.SetPosition(id0);
        this.updateTextLoc();
    }

    public void SetPosition(double id0, double id1, double id2) {
        super.SetPosition(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetOrientation(double[] id0) {
        super.SetOrientation(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetScale(double id0, double id1, double id2) {
        super.SetScale(id0, id1, id2);
        this.updateTextLoc();
    }

    public void SetScale(double[] id0) {
        super.SetScale(id0);
        this.updateTextLoc();
    }

    public void SetColor(double r, double g, double b) {
        this.coneActor.GetProperty().SetColor(r, g, b);
        this.tubeActor.GetProperty().SetColor(r, g, b);
        this.coneActor.GetProperty().Delete();
        this.tubeActor.GetProperty().Delete();
    }

    public void SetTextColor(double r, double g, double b) {
        this.tactor.GetTextProperty().SetColor(r, g, b);
        this.tactor.GetTextProperty().Delete();
    }

    public void SetUserMatrix(vtkMatrix4x4 id0) {
        super.SetUserMatrix(id0);
        this.updateTextLoc();
    }

    public void SetUserTransform(vtkLinearTransform id0) {
        super.SetUserTransform(id0);
        this.updateTextLoc();
    }

    public void Delete() {
        this.ren.RemoveActor((vtkProp)this.tactor);
        this.ren.RemoveActor((vtkProp)this.tubeActor);
        this.ren.RemoveActor((vtkProp)this.coneActor);
        this.tactor.Delete();
        this.tubeActor.Delete();
        this.coneActor.Delete();
        super.Delete();
    }

    public void dispose() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                axisActor.this.removeFromRenderer();
                axisActor.this.Delete();
            }
        });
    }

    @Override
    public vtkProp3D getVtkProp() {
        return this;
    }
}

