/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Base64;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.util.EvaluatingListener;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.ValueIndexVariable;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Book;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Shadow;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.utils.GetConfigurationRequest;
import org.simantics.sysdyn.utils.ModuleSummary;
import org.simantics.sysdyn.utils.ModuleSummaryRequest;
import org.simantics.sysdyn.utils.imports.ImportUtils;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;

public class DocumentationUtils {
    public static List<Resource> getModules(ReadGraph graph, Variable model) throws DatabaseException {
        if (model == null) {
            return Collections.emptyList();
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource modelResource = model.getRepresents(graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (graph.isInstanceOf(modelResource, SR.SysdynModel)) {
            result.add(modelResource);
            result.addAll((Collection)graph.syncRequest((Read)new ObjectsWithSupertype(modelResource, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SR.Module)));
        }
        return result;
    }

    public static List<Variable> getExperimentVariables(ReadGraph graph, Variable model) throws DatabaseException {
        if (model == null) {
            return Collections.emptyList();
        }
        ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
        if (model == null || !graph.isInstanceOf(model.getRepresents(graph), MR.StructuralModel)) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Resource config : graph.getObjects(model.getRepresents(graph), L0.ConsistsOf)) {
            if (!graph.isInstanceOf(config, SIMU.Experiment)) continue;
            for (Resource run : graph.getObjects(config, L0.ConsistsOf)) {
                Variable runVar;
                if (!graph.isInstanceOf(run, SIMU.Run) || !graph.hasStatement(run, SIMU.IsActive) || (runVar = Variables.getPossibleVariable((ReadGraph)graph, (Resource)run)) == null) continue;
                result.add(runVar);
            }
        }
        return result;
    }

    public static List<Variable> getRoleVariables(ReadGraph graph, Variable experiment) throws DatabaseException {
        if (experiment == null) {
            return Collections.emptyList();
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(experiment.getRepresents(graph), SIMU.Run)) {
            experiment = experiment.getParent(graph);
        }
        if (!graph.isInstanceOf(experiment.getRepresents(graph), SIMU.Experiment)) {
            return Collections.emptyList();
        }
        Resource roleType = graph.getPossibleResource("http://www.semantum.fi/Simupedia-1.0/Role");
        if (roleType == null) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable part : experiment.getChildren(graph)) {
            if (!graph.isInstanceOf(part.getRepresents(graph), roleType)) continue;
            result.add(part);
        }
        return result;
    }

    public static List<Variable> getDocumentVariables(ReadGraph graph, Variable model) throws DatabaseException {
        if (model == null) {
            return Collections.emptyList();
        }
        Resource documentType = graph.getPossibleResource("http://www.simantics.org/Documentation-1.2/Document");
        if (documentType == null) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable part : model.getChildren(graph)) {
            if (!graph.isInstanceOf(part.getRepresents(graph), documentType)) continue;
            result.add(part);
        }
        return result;
    }

    public static List<Variable> getResultVariables(ReadGraph graph, Variable model) throws DatabaseException {
        if (model == null) {
            return Collections.emptyList();
        }
        Variable library = model.getPossibleChild(graph, "PDFLibrary");
        if (library == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Variable>(library.getChildren(graph));
    }

    public static List<Variable> getIndexDocuments(ReadGraph graph, Variable project) throws DatabaseException {
        Resource indexRelation = graph.getPossibleResource("http://www.semantum.fi/Simupedia-1.0/indexDocument");
        if (indexRelation == null) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable model : project.getChildren(graph)) {
            Resource indexDocumentResource;
            Resource modelResource = model.getRepresents(graph);
            if (modelResource == null || (indexDocumentResource = graph.getPossibleObject(modelResource, indexRelation)) == null) continue;
            Variable indexDoc = Variables.getVariable((ReadGraph)graph, (Resource)indexDocumentResource);
            result.add(indexDoc);
        }
        return result;
    }

    public static Resource getConfiguration(ReadGraph graph, Resource module) throws DatabaseException {
        if (module == null) {
            return null;
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(module, SR.SysdynModel)) {
            return graph.getSingleObject(module, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        }
        if (graph.isInheritedFrom(module, SR.Module)) {
            return graph.getSingleObject(module, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
        }
        return null;
    }

    public static List<Resource> getConfigurationVariables(ReadGraph graph, Resource configuration) throws DatabaseException {
        if (configuration == null) {
            return Collections.emptyList();
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration);
        ArrayList<IElement> elements = new ArrayList<IElement>();
        for (IElement element : sm.getConfiguration().getElements()) {
            if (!(element instanceof org.simantics.sysdyn.representation.Variable) && !(element instanceof Module) || element instanceof Book || element instanceof Shadow) continue;
            elements.add(element);
        }
        Collections.sort(elements, new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                if (!this.isApplied(o1) || !this.isApplied(o2)) {
                    return 0;
                }
                String name1 = this.getName(o1);
                String name2 = this.getName(o2);
                return name1.compareTo(name2);
            }

            private boolean isApplied(IElement element) {
                return (element instanceof org.simantics.sysdyn.representation.Variable || element instanceof Module) && !(element instanceof Book);
            }

            private String getName(IElement element) {
                if (element instanceof org.simantics.sysdyn.representation.Variable) {
                    return ((org.simantics.sysdyn.representation.Variable)element).getName();
                }
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                return "";
            }
        });
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (IElement e : elements) {
            result.add(sm.getMapping().inverseGet((Object)e));
        }
        return result;
    }

    public static String getName(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            org.simantics.sysdyn.representation.Variable v = (org.simantics.sysdyn.representation.Variable)element;
            StringBuilder sb = new StringBuilder();
            sb.append(v.getModelicaName());
            if (v.getArrayIndexes() != null && v.getArrayIndexes().size() > 0) {
                sb.append("[");
                boolean first = true;
                for (Enumeration e : v.getArrayIndexes()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(e.getModelicaName());
                }
                sb.append("]");
            }
            return sb.toString();
        }
        if (element instanceof Module) {
            Module m = (Module)element;
            return m.getName();
        }
        return "";
    }

    public static String getType(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            String result = ((org.simantics.sysdyn.representation.Variable)element).getType();
            if (result == null) {
                return "";
            }
            return String.valueOf(element.getClass().getSimpleName()) + " " + result;
        }
        if (element instanceof Module) {
            Module m = (Module)element;
            return "Module " + m.getType().getName();
        }
        return "";
    }

    public static String getUnit(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            String result = ((org.simantics.sysdyn.representation.Variable)element).getUnit();
            if (result == null) {
                return "";
            }
            return result;
        }
        return "";
    }

    public static String getVariability(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof Stock) {
            return "";
        }
        if (element instanceof IndependentVariable) {
            Variability variability = Variability.getVariability((IndependentVariable)element);
            if (variability == Variability.CONTINUOUS) {
                return "";
            }
            return variability.toString().toLowerCase();
        }
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            String result = ((org.simantics.sysdyn.representation.Variable)element).getVariability();
            if (result == null) {
                return "";
            }
            return result;
        }
        return "";
    }

    public static String getDescription(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            String result = ((org.simantics.sysdyn.representation.Variable)element).getDescription();
            if (result == null) {
                return "";
            }
            return result;
        }
        return "";
    }

    public static String getDocumentationDefinition(ReadGraph graph, Resource variable) throws DatabaseException {
        Resource configuration;
        if (variable == null) {
            return null;
        }
        SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration = (Resource)graph.syncRequest((Read)new GetConfigurationRequest(variable)));
        IElement element = sm.getElement(variable);
        if (element instanceof org.simantics.sysdyn.representation.Variable) {
            org.simantics.sysdyn.representation.Variable v = (org.simantics.sysdyn.representation.Variable)element;
            String result = v.getDocumentationDefinition(graph);
            if (result == null) {
                return "";
            }
            return result;
        }
        if (element instanceof Module) {
            Module m = (Module)element;
            return m.getDocumentationDefinition();
        }
        return "";
    }

    public static int numberOfVariables(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getVariables();
    }

    public static int totalNumberOfVariables(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getTotalVariables();
    }

    public static int numberOfStocks(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getStocks();
    }

    public static int numberOfValves(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getValves();
    }

    public static int numberOfInputs(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getInputs();
    }

    public static int numberOfShadows(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getShadows();
    }

    public static int numberOfAuxiliaries(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getAuxiliaries();
    }

    public static int numberOfModules(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getModules();
    }

    public static int numberOfSheets(ReadGraph graph, Resource configuration, boolean recursive) throws DatabaseException {
        return ((ModuleSummary)graph.syncRequest((Read)new ModuleSummaryRequest(configuration, recursive))).getSheets();
    }

    public static int numberOfModuleTypes(ReadGraph graph, Variable model) throws DatabaseException {
        if (model == null) {
            return 0;
        }
        Resource modelResource = model.getRepresents(graph);
        return ((Set)graph.syncRequest((Read)new ObjectsWithSupertype(modelResource, Layer0.getInstance((ReadGraph)graph).ConsistsOf, SysdynResource.getInstance((ReadGraph)graph).Module))).size();
    }

    public static String base64Encode(ReadGraph graph, Variable variable, String property) throws DatabaseException {
        byte[] fileBArray = (byte[])variable.getPossiblePropertyValue(graph, property, (Binding)Bindings.BYTE_ARRAY);
        if (fileBArray != null) {
            return Base64.encode((byte[])fileBArray);
        }
        return "";
    }

    public static String formatDate(long timeMillis) {
        Date date = new Date(timeMillis);
        String result = DateFormat.getDateInstance().format(date);
        return result;
    }

    public static Resource importModel(String path) {
        final DataContainer m = new DataContainer();
        try {
            ImportUtils.importModelFile(path, (IProgressMonitor)new NullProgressMonitor(), (Function1<Resource, WriteRequest>)new FunctionImpl1<Resource, WriteRequest>(){

                public WriteRequest apply(Resource model) {
                    m.set((Object)model);
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Resource)m.get();
    }

    public static boolean isParameter(ReadGraph graph, Variable variable) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource represents = variable.getPossibleRepresents(graph);
        System.out.println(graph.getURI(represents));
        if (represents == null || !graph.isInstanceOf(represents, SR.IndependentVariable)) {
            return false;
        }
        Resource expressionList = graph.getPossibleObject(represents, SR.Variable_expressionList);
        if (expressionList == null) {
            return false;
        }
        List expressions = ListUtils.toList((ReadGraph)graph, (Resource)expressionList);
        if (expressions == null || expressions.size() != 1) {
            return false;
        }
        Resource expression = (Resource)expressions.get(0);
        return graph.isInstanceOf(expression, SR.ParameterExpression);
    }

    public static double lastValue(final Resource experiment, final String runId, final String path) throws DatabaseException {
        try {
            double[] values = (double[])EvaluatingListener.trySyncRequest((Session)Simantics.getSession(), (Read)new UniqueRead<double[]>(){

                public double[] perform(ReadGraph graph) throws DatabaseException {
                    Variable var = Variables.getVariable((ReadGraph)graph, (Resource)experiment);
                    if (var == null) {
                        return null;
                    }
                    Variable run = var.getPossibleChild(graph, runId);
                    if (run == null) {
                        return null;
                    }
                    Variable v = run.browsePossible(graph, String.valueOf(path) + "#value#");
                    if (v == null) {
                        return null;
                    }
                    return (double[])v.getPossibleValue(graph);
                }
            }, (EvaluatingListener.Criterion)new EvaluatingListener.Criterion<double[]>(){

                public EvaluatingListener.Evaluation evaluate(double[] result) {
                    if (result == null) {
                        return EvaluatingListener.Evaluation.DISCARD;
                    }
                    return result != ValueIndexVariable.UNRESOLVED ? EvaluatingListener.Evaluation.ACCEPT : EvaluatingListener.Evaluation.IGNORE;
                }
            }, (long)15L, (TimeUnit)TimeUnit.SECONDS);
            return values[0];
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    public static Variable lastValue2(ReadGraph graph, Variable input, String path) throws DatabaseException {
        if (input == null) {
            return null;
        }
        Variable context = Variables.getPossibleContext((ReadGraph)graph, (Variable)input);
        if (context == null && (context = Variables.getConfigurationContext((ReadGraph)graph, (Variable)input)) == null) {
            return null;
        }
        Variable v = context.browsePossible(graph, "/" + path);
        if (v == null) {
            return null;
        }
        Variable p = v.browsePossible(graph, "#value#$0");
        if (p == null) {
            return null;
        }
        return p;
    }

    public static Variable currentValue(ReadGraph graph, Variable input, String path) throws DatabaseException {
        if (input == null) {
            return null;
        }
        Variable context = Variables.getPossibleContext((ReadGraph)graph, (Variable)input);
        if (context == null && (context = Variables.getConfigurationContext((ReadGraph)graph, (Variable)input)) == null) {
            return null;
        }
        Variable v = context.browsePossible(graph, "/" + path);
        if (v == null) {
            return null;
        }
        Variable p = v.browsePossible(graph, "#value#$0");
        if (p == null) {
            return null;
        }
        return p;
    }

    public static Pair<String, String> splitToNameAndIndices(String reference) {
        Pattern indexPattern = Pattern.compile("^([^\\[]*)\\[([^\\]]*)]$");
        Matcher m = indexPattern.matcher(reference);
        if (m.matches()) {
            String name = m.group(1);
            String indices = m.group(2).trim().replaceAll("\\s*,\\s*", ",");
            return Pair.make((Object)name, (Object)indices);
        }
        return Pair.make((Object)reference, (Object)"");
    }

    public static Variable lastValueIndexed(ReadGraph graph, Variable run, String path) throws DatabaseException {
        if (run == null) {
            throw new DatabaseException("Input variable (run) is null");
        }
        return (Variable)graph.syncRequest((Read)new LastValueIndexed(run, path));
    }

    public static Variable equation(ReadGraph graph, Variable input, String path) throws DatabaseException {
        if (input == null) {
            return null;
        }
        Variable context = Variables.getPossibleContext((ReadGraph)graph, (Variable)input);
        if (context == null && (context = Variables.getConfigurationContext((ReadGraph)graph, (Variable)input)) == null) {
            return null;
        }
        Variable v = context.browsePossible(graph, "/" + path);
        if (v == null) {
            return null;
        }
        Variable p = v.browsePossible(graph, "#equation");
        if (p == null) {
            return null;
        }
        return p;
    }

    public static class LastValueIndexed
    extends BinaryRead<Variable, String, Variable>
    implements ReadExt {
        public LastValueIndexed(Variable run, String path) {
            super((Object)run, (Object)path);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            try {
                Pair<String, String> nameAndIndices = DocumentationUtils.splitToNameAndIndices((String)this.parameter2);
                Variable v = ((Variable)this.parameter).browsePossible(graph, "/" + (String)nameAndIndices.first + "#value#" + (String)nameAndIndices.second);
                if (v == null) {
                    throw new MissingVariableException("No variable for SysDyn reference path: " + (String)this.parameter2 + " from variable " + ((Variable)this.parameter).getURI(graph));
                }
                return v;
            }
            catch (Throwable e) {
                throw new DatabaseException(e);
            }
        }

        public boolean isImmutable(ReadGraph graph) throws DatabaseException {
            return false;
        }

        public int getType() {
            return 1;
        }
    }
}

