/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.MdlVariable;
import org.simantics.sysdyn.modelImport.mdl.Sketch;
import org.simantics.sysdyn.modelImport.mdl.SketchElement;
import org.simantics.sysdyn.modelImport.model.Auxiliary;
import org.simantics.sysdyn.modelImport.model.Stock;
import org.simantics.sysdyn.modelImport.model.Variable;
import org.simantics.sysdyn.modelImport.model.expression.Expression;

public class SketchVariable
extends SketchElement {
    private static final String SKETCH_VARIABLE = "10,([+-]?\\d+),([A-Za-z]\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"),(([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),([+-]?\\d+),[+-]?\\d+,[+-]?\\d+,([+-]?\\d+),.*)";
    private static final int variableId = 1;
    private static final int variableName = 2;
    private static final int variableSuffix = 3;
    private String name;

    protected SketchVariable(int id, Sketch sketch, String name) {
        super(id, sketch);
        this.name = name;
    }

    public static SketchVariable getPossible(String line, Sketch sketch) throws Exception {
        Matcher matcher = Pattern.compile(SKETCH_VARIABLE).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        int id = Integer.parseInt(matcher.group(1));
        String name = MdlUtil.normalize(matcher.group(2));
        SketchVariable element = new SketchVariable(id, sketch, name);
        element.parseSuffix(matcher.group(3));
        return element;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Variable getSymbol() {
        MdlVariable variable = this.getSketch().getMdl().getVariable(this.name);
        if (variable == null) {
            return null;
        }
        Expression expr = variable.getExpression();
        Variable var = expr != null && expr.getExpressionTypeString().equals("StockExpression") ? new Stock() : new Auxiliary();
        var.setDimensions(this.getDimensions());
        return variable.initVariable(var);
    }
}

