/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.scl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.AbstractCompileStructuralValueRequest;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;

public class CompileStructuralValueRequest
extends AbstractCompileStructuralValueRequest {
    protected final Resource component;
    protected final Resource literal;

    public CompileStructuralValueRequest(Resource component, Resource literal, Resource relation) {
        super(relation);
        this.component = component;
        this.literal = literal;
    }

    public CompileStructuralValueRequest(ReadGraph graph, Variable context) throws DatabaseException {
        this(context.getParent(graph).getRepresents(graph), context.getRepresents(graph), context.getPredicateResource(graph));
    }

    public static Object compileAndEvaluate(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        CompileStructuralValueRequest request = new CompileStructuralValueRequest(graph, context);
        try {
            Function1 exp = (Function1)graph.syncRequest((Read)request, (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)context);
            return object;
        }
        catch (Throwable t) {
            String componentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)request.component);
            String literalName = NameUtils.getSafeName((ReadGraph)graph, (Resource)request.literal);
            String relationName = NameUtils.getSafeName((ReadGraph)graph, (Resource)request.relation);
            StringBuilder sb = new StringBuilder("Compiling structural value request for component ").append(componentName).append(" ").append(request.component).append(" , literal ").append(literalName).append(" ").append(request.literal).append(" and relation ").append(relationName).append(" ").append(request.relation).append(" failed!");
            throw new DatabaseException(sb.toString(), t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    @Override
    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (String)graph.getRelatedValue(this.literal, L0.SCLValue_expression, (Binding)Bindings.STRING);
    }

    @Override
    protected Resource getIndexRoot(ReadGraph graph) throws DatabaseException {
        return (Resource)graph.syncRequest((Read)new IndexRoot(this.literal));
    }

    @Override
    protected Resource getComponentType(ReadGraph graph) throws DatabaseException {
        if (this.component == null) {
            return null;
        }
        return (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(this.component));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CompileStructuralValueRequest other = (CompileStructuralValueRequest)((Object)obj);
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
    }
}

