/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.AdaptableHintContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleVariable;
import org.simantics.db.layer0.request.PossibleVariableRepresents;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.ExplorerInputContentType;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardWorkbenchSelectionElement
extends AdaptableHintContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardWorkbenchSelectionElement.class);
    public final WorkbenchSelectionElement wse;
    public final Object content;
    public final Resource resource;
    public final Variable variable;
    public final Object input;

    public static WorkbenchSelectionElement nodeContextToWorkbenchSelectionElement(NodeContext context) {
        return new StandardWorkbenchSelectionElement(context);
    }

    private WorkbenchSelectionElement extractWse(Object content) {
        NodeContext context;
        Object input;
        if (content instanceof NodeContext && (input = (context = (NodeContext)content).getConstant(NodeType.TYPE)) instanceof NodeType) {
            return ((NodeType)input).getWorkbenchSelectionElement(context);
        }
        return null;
    }

    private Resource extractResource(Object content) {
        if (content instanceof NodeContext) {
            Resource var;
            NodeContext context = (NodeContext)content;
            Object input = context.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Resource) {
                return (Resource)input;
            }
            if (input instanceof IAdaptable && (var = (Resource)((IAdaptable)input).getAdapter(Resource.class)) != null) {
                return var;
            }
        }
        return null;
    }

    private Variable extractVariable(Object content) {
        if (content instanceof NodeContext) {
            Variable var;
            NodeContext context = (NodeContext)content;
            Object input = context.getConstant(BuiltinKeys.INPUT);
            if (input instanceof Variable) {
                return (Variable)input;
            }
            if (input instanceof IAdaptable && (var = (Variable)((IAdaptable)input).getAdapter(Variable.class)) != null) {
                return var;
            }
        }
        return null;
    }

    private Object extractInput(Object content) {
        if (content instanceof NodeContext) {
            NodeContext context = (NodeContext)content;
            return context.getConstant(BuiltinKeys.INPUT);
        }
        return null;
    }

    public StandardWorkbenchSelectionElement(Object content) {
        super(new IHintContext.Key[0]);
        this.content = content;
        this.wse = this.extractWse(content);
        this.resource = this.extractResource(content);
        this.variable = this.extractVariable(content);
        this.input = this.extractInput(content);
    }

    public <T> T getContent(WorkbenchSelectionContentType<T> contentType) {
        Object result;
        if (this.wse != null && (result = this.wse.getContent(contentType)) != null) {
            return (T)result;
        }
        if (contentType instanceof AnyResource) {
            if (this.resource != null) {
                return (T)this.resource;
            }
            if (this.variable == null) {
                return null;
            }
            try {
                return (T)((AnyResource)contentType).processor.syncRequest((Read)new PossibleVariableRepresents(this.variable));
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected error occurred while resolving Resource from Variable " + this.variable, (Throwable)e);
            }
        } else if (contentType instanceof AnyVariable) {
            if (this.variable != null) {
                return (T)this.variable;
            }
            if (this.resource == null) {
                return null;
            }
            try {
                return (T)((AnyVariable)contentType).processor.syncRequest((Read)new PossibleVariable(this.resource));
            }
            catch (DatabaseException e) {
                LOGGER.error("Unexpected error occurred while resolving Variable from Resource " + this.resource, (Throwable)e);
            }
        } else if (contentType instanceof ExplorerInputContentType) {
            return (T)this.input;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (WorkbenchSelectionElement.class == adapter) {
            return this.wse;
        }
        if (NodeContext.class == adapter) {
            if (this.content instanceof NodeContext) {
                return (NodeContext)this.content;
            }
            return null;
        }
        return super.getAdapter(adapter);
    }
}

