/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.validation;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class L0Validations {
    public static String checkValueType(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        if (subject == null) {
            return null;
        }
        if (predicate == null) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(predicate, L0.HasProperty)) {
            String valueType2;
            Resource object = graph.getPossibleObject(subject, predicate);
            if (object == null) {
                return null;
            }
            String valueType = (String)graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (valueType != null && !valueType.equals(valueType2 = (String)graph.getPossibleRelatedValue(object, L0.HasValueType, (Binding)Bindings.STRING))) {
                StringBuilder sb = new StringBuilder().append("The value type ").append(valueType).append(" of predicate ").append(NameUtils.getSafeName(graph, predicate, true)).append(" does not match the value type ").append(valueType2).append(" of object ").append(NameUtils.getSafeName(graph, object, true)).append(".");
                return sb.toString();
            }
        }
        return null;
    }
}

