/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnescapedChildMapOfResource
extends ResourceRead<Map<String, Resource>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnescapedChildMapOfResource.class);

    public UnescapedChildMapOfResource(Resource resource) {
        super(resource);
    }

    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection objects = graph.getObjects(this.resource, L0.ConsistsOf);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Map result = (Map)cs.createObjectResourceMap(String.class, objects.size());
        for (Resource r : objects) {
            Resource old;
            String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
            if (name == null || (old = result.put(name, r)) == null) continue;
            LOGGER.error("The database contains siblings with the same name " + name + " (resource=$" + this.resource.getResourceId() + ", child=$" + r.getResourceId() + ", previous child=$" + old.getResourceId() + ").");
        }
        return result;
    }
}

