/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;

public final class SyncToAsyncListener<T>
implements AsyncListener<T> {
    private final SyncListener<T> procedure;

    public SyncToAsyncListener(SyncListener<T> procedure) {
        this.procedure = procedure;
    }

    public final void execute(AsyncReadGraph graph, final T result) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SyncToAsyncListener.this.procedure.execute(graph, result);
            }

            public String toString() {
                return "execute for " + SyncToAsyncListener.this.toString();
            }
        }, (Procedure)new Procedure<Object>(){

            public void exception(Throwable t) {
                Logger.defaultLogError(t);
            }

            public void execute(Object result) {
            }
        });
    }

    public final void exception(AsyncReadGraph graph, final Throwable t) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SyncToAsyncListener.this.procedure.exception(graph, t);
            }
        });
    }

    public boolean isDisposed() {
        return this.procedure.isDisposed();
    }

    public String toString() {
        return "SyncToAsyncListener -> " + this.procedure;
    }
}

