/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.simantics.utils.ObjectUtils;

public class TextImageDescriptor
extends ImageDescriptor {
    static final PaletteData _RGB = new PaletteData(0xFF0000, 65280, 255);
    public String text;
    public int width;
    public int height;
    public String font;
    public int fontSize;
    public int style;
    public int rgb;
    private transient int hash;

    public TextImageDescriptor(String text, int width, int height, String font, int fontSize, int style, int rgb) {
        this.text = text;
        this.width = width;
        this.height = height;
        this.font = font;
        this.fontSize = fontSize;
        this.style = style;
        this.rgb = rgb;
        this.hash = text.hashCode() + 3 * width + 5 * height + 7 * font.hashCode() + 11 * fontSize + 13 * style + 17 * rgb;
    }

    public ImageData getImageData(int zoom) {
        int w = this.width;
        int h = this.height;
        int fs = this.fontSize;
        if (zoom > 100) {
            float s = (float)zoom / 100.0f;
            w = Math.round((float)this.width * s);
            h = Math.round((float)this.height * s);
            fs = Math.round((float)this.fontSize * s);
        }
        return this.getImageData(w, h, fs);
    }

    private ImageData getImageData(int width, int height, int fontSize) {
        ImageData id = new ImageData(width, height, 24, _RGB);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font f = new Font(this.font, this.style, fontSize);
        g.setFont(f);
        Color c = new Color(this.rgb);
        g.setColor(c);
        FontMetrics fm = g.getFontMetrics(f);
        Rectangle2D rect = fm.getStringBounds(this.text, g);
        g.drawString(this.text, (float)(((double)width - rect.getWidth()) / 2.0), (float)((double)(height / 2) + ((double)height - rect.getHeight()) / 2.0));
        g.dispose();
        WritableRaster alpha = bi.getAlphaRaster();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int a = alpha.getSample(x, y, 0);
                int rgb = bi.getRGB(x, y);
                id.setAlpha(x, y, a);
                id.setPixel(x, y, rgb);
                ++y;
            }
            ++x;
        }
        return id;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextImageDescriptor)) {
            return false;
        }
        TextImageDescriptor o = (TextImageDescriptor)((Object)obj);
        if (!ObjectUtils.objectEquals((Object)this.text, (Object)o.text)) {
            return false;
        }
        if (!ObjectUtils.objectEquals((Object)this.font, (Object)o.font)) {
            return false;
        }
        return this.width == o.width && this.height == o.height && this.fontSize == o.fontSize && this.style == o.style && this.rgb == o.rgb;
    }
}

