/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorComposite;
import org.simantics.utils.ui.color.ColorIconCreator;

public class ColorDialog
extends Dialog {
    protected ColorComposite colorComposite;
    protected Color value;

    public ColorDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Color");
    }

    public void setInitialValue(Color initialValue) {
        this.value = new Color(initialValue);
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(6, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)composite);
        this.colorComposite = new ColorComposite(composite, 0);
        GridData childData = new GridData(1808);
        this.colorComposite.setLayoutData(childData);
        if (this.value != null) {
            this.colorComposite.setColor(this.value);
        }
        Group builtinGroup = new Group(composite, 0);
        builtinGroup.setText("System colors");
        GridLayoutFactory.fillDefaults().numColumns(8).spacing(2, 2).margins(4, 4).applyTo((Composite)builtinGroup);
        int i = 1;
        while (i <= 16) {
            org.eclipse.swt.graphics.Color c = Display.getCurrent().getSystemColor(i);
            Color color = new Color(c.getRGB());
            this.createColorButton((Composite)builtinGroup, color);
            ++i;
        }
        return composite;
    }

    protected Button createColorButton(Composite parent, final Color color) {
        Button button = new Button(parent, 8);
        button.setImage(ColorIconCreator.createImage(color, 32, 2048));
        button.setData((Object)color);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog.this.colorComposite.setColor(color);
            }
        });
        return button;
    }

    public Color getColor() {
        return this.colorComposite.getColor();
    }
}

