/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.simantics.document.ui.CSSTextEditorEnvironment;

public class CSSEditorTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private CSSTextEditorEnvironment sclTextEditorEnvironment;

    public CSSEditorTextHover(ISourceViewer sourceViewer, CSSTextEditorEnvironment sclTextEditorEnvironment) {
        this.sclTextEditorEnvironment = sclTextEditorEnvironment;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return CSSEditorTextHover.findWord(textViewer.getDocument(), offset);
    }

    private static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        String info = null;
        try {
            IDocument document = textViewer.getDocument();
            String text = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
            this.sclTextEditorEnvironment.updateEnvironment(document);
            info = this.sclTextEditorEnvironment.getHoverInfo(text);
        }
        catch (BadLocationException badLocationException) {}
        return info;
    }

    public IInformationControlCreator getHoverControlCreator() {
        AbstractReusableInformationControlCreator creator = new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
        return creator;
    }
}

