/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.annotation.ui.AnnotationUtils;
import org.simantics.annotation.ui.SCL;
import org.simantics.annotation.ui.wizard.AnnotationTypeExporter;
import org.simantics.annotation.ui.wizard.AnnotationTypeImportWizard;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.UnescapedPropertyMapOfResource;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.utils.datastructures.Pair;

public class SCLAnnotation {
    public static Resource newAnnotationType(WriteGraph graph, Resource parent) throws DatabaseException {
        Pair<Resource, Resource> annotation = AnnotationUtils.newAnnotationType(graph, parent);
        Resource type = (Resource)annotation.second;
        return type;
    }

    public static Tuple2 newAnnotationType1(WriteGraph graph, Resource parent) throws DatabaseException {
        Pair<Resource, Resource> annotation = AnnotationUtils.newAnnotationType(graph, parent);
        Tuple2 tuple = new Tuple2(annotation.first, annotation.second);
        return tuple;
    }

    public static Resource newAnnotationValue(WriteGraph graph, Resource parent, Resource property) throws DatabaseException {
        graph.markUndoPoint();
        Resource annotationValue = AnnotationUtils.newAnnotationInstance(graph, parent, property);
        return annotationValue;
    }

    public static Resource newAnnotationValueWithName(WriteGraph graph, Resource parent, String name, Resource property) throws DatabaseException {
        Resource existing = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)parent, (String)name);
        if (existing != null) {
            return existing;
        }
        Resource annotationValue = AnnotationUtils.newAnnotationInstance(graph, parent, name, property);
        return annotationValue;
    }

    public static Resource newAnnotationProperty(WriteGraph graph, Resource annotationType) throws DatabaseException {
        Resource annotationProperty = ComponentTypeCommands.createPropertyWithDefaults((WriteGraph)graph, (Resource)annotationType);
        return annotationProperty;
    }

    public static Resource advancedAnnotationProperty(WriteGraph graph, Resource annotationType, String name, String value, String unit, String range, String label, String description) throws DatabaseException {
        Resource property = ComponentTypeCommands.createProperty((WriteGraph)graph, (Resource)annotationType, (String)name, (String)value, (String)unit, (String)range, (String)label, (String)description);
        return property;
    }

    public static void removeAnnotationProperty(WriteGraph graph, Resource property) throws DatabaseException {
        Resource annotationType = SCLAnnotation.getAnnotationType((ReadGraph)graph, property);
        ComponentTypeCommands.removeProperty((WriteGraph)graph, (Resource)annotationType, (Resource)property);
    }

    public static void setPropertyType(WriteGraph graph, Resource property, String type) throws DatabaseException {
        Resource annotationType = SCLAnnotation.getAnnotationType((ReadGraph)graph, property);
        ComponentTypeCommands.setRequiredType((WriteGraph)graph, (Resource)property, (String)type);
        ComponentTypeCommands.convertDefaultValue((WriteGraph)graph, (Resource)annotationType, (Resource)property, (String)type);
    }

    public static void setPropertyUnit(WriteGraph graph, Resource property, String unit) throws DatabaseException {
        Resource annotationType = SCLAnnotation.getAnnotationType((ReadGraph)graph, property);
        ComponentTypeCommands.setUnit((WriteGraph)graph, (Resource)property, (Resource)annotationType, (String)unit);
    }

    public static void setPropertyLabel(WriteGraph graph, Resource property, String label) throws DatabaseException {
        ComponentTypeCommands.setLabel((WriteGraph)graph, (Resource)property, (String)label);
    }

    public static void setPropertyRange(WriteGraph graph, Resource property, String range) throws DatabaseException {
        Resource annotationType = SCLAnnotation.getAnnotationType((ReadGraph)graph, property);
        ComponentTypeCommands.setRange((WriteGraph)graph, (Resource)property, (Resource)annotationType, (String)range);
    }

    public static void setPropertyDescription(WriteGraph graph, Resource property, String description) throws DatabaseException {
        ComponentTypeCommands.setDescription((WriteGraph)graph, (Resource)property, (String)description);
    }

    public static void setDefaultValue(WriteGraph graph, Resource property, String value) throws DatabaseException {
        Resource annotationType = SCLAnnotation.getAnnotationType((ReadGraph)graph, property);
        ComponentTypeCommands.setDefaultValue((WriteGraph)graph, (Resource)annotationType, (Resource)property, (String)value);
    }

    public static Resource attachAnnotation(WriteGraph graph, Resource parent, Resource annotationType) throws DatabaseException {
        Resource annotation = AnnotationUtils.newAnnotation(graph, parent, annotationType);
        return annotation;
    }

    public static Resource getAnnotationType(ReadGraph graph, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource annotationType = graph.getPossibleObject(property, L0.PartOf);
        return annotationType;
    }

    public static Resource saveAnnotation(WriteGraph graph, Resource annotation, Resource library, String name) throws DatabaseException {
        return SCL.SaveModifier.saveAnnotation(graph, annotation, library, name);
    }

    public static void importAnnotationFromFile(File importLocation, Resource target) throws SerializationException, IOException, DatabaseException {
        Session session = Simantics.getSession();
        AnnotationTypeImportWizard.doImport((IProgressMonitor)new NullProgressMonitor(), importLocation, session, target);
    }

    public static void exportAnnotationToFile(File location, Resource annotationType) throws DatabaseException, IOException {
        AnnotationTypeExporter.doExport(location, annotationType);
    }

    public static void rename(WriteGraph graph, Resource resource, String newName) throws DatabaseException {
        ComponentTypeCommands.rename((WriteGraph)graph, (Resource)resource, (String)newName);
    }

    public static void copyAnnotationData(WriteGraph graph, Resource source, Resource target) throws DatabaseException {
        Map sps = (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(source));
        Map tps = (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(target));
        for (PropertyInfo sp : sps.values()) {
            PropertyInfo tp = (PropertyInfo)tps.get(sp.name);
            if (tp == null) continue;
            for (Statement srcstm : graph.getStatements(source, sp.predicate)) {
                if (srcstm.isAsserted(source)) {
                    graph.deny(target, sp.predicate);
                    continue;
                }
                Resource property = srcstm.getObject();
                for (Statement tgtstm : graph.getStatements(target, tp.predicate)) {
                    if (tgtstm.isAsserted(target)) continue;
                    graph.deny(tgtstm);
                }
                graph.deny(source, sp.predicate, property);
                graph.claim(target, tp.predicate, property);
            }
        }
    }
}

