/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.runtime;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class DiagramSelectionUpdater
extends HintListenerAdapter {
    private static final boolean DEBUG_SELECTION_UPDATE = false;
    private final ICanvasContext ctx;
    private final Selection selection;
    private final IDiagram diagram;
    private int selectionId;
    private AtomicReference<Set<?>> newSelection = new AtomicReference();
    private boolean oneshot = false;
    private boolean tracking = false;

    public DiagramSelectionUpdater(ICanvasContext ctx) {
        this.ctx = ctx;
        this.selection = (Selection)ctx.getAtMostOneItemOfClass(Selection.class);
        if (this.selection == null) {
            throw new IllegalArgumentException("no selection participant");
        }
        this.diagram = (IDiagram)ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        if (this.diagram == null) {
            throw new IllegalArgumentException("no diagram");
        }
    }

    public DiagramSelectionUpdater(ICanvasContext ctx, IDiagram diagram) {
        this.ctx = ctx;
        this.selection = (Selection)ctx.getAtMostOneItemOfClass(Selection.class);
        if (this.selection == null) {
            throw new IllegalArgumentException("no selection participant");
        }
        this.diagram = diagram;
        if (diagram == null) {
            throw new IllegalArgumentException("no diagram");
        }
    }

    protected Selection getSelectionParticipant() {
        return (Selection)this.ctx.getSingleItem(Selection.class);
    }

    public DiagramSelectionUpdater setNewSelection(int selectionId, Set<?> newSelection) {
        this.selectionId = selectionId;
        this.newSelection.set(newSelection);
        return this;
    }

    public Set<?> getNewSelection() {
        return this.newSelection.get();
    }

    public DiagramSelectionUpdater setOneshot(boolean oneshot) {
        this.oneshot = oneshot;
        return this;
    }

    public DiagramSelectionUpdater track() {
        if (!this.tracking) {
            this.diagram.addKeyHintListener(DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED, (IHintListener)this);
            this.tracking = true;
        }
        return this;
    }

    public DiagramSelectionUpdater untrack() {
        if (this.tracking) {
            this.diagram.removeKeyHintListener(DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED, (IHintListener)this);
            this.tracking = false;
        }
        return this;
    }

    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        Set ns;
        if (!this.ctx.isDisposed() && key == DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED && (ns = (Set)this.newSelection.getAndSet(null)) != null) {
            this.scheduleSetDiagramSelection(2, ns);
        }
        if (this.oneshot) {
            sender.removeHintListener((IHintListener)this);
        }
    }

    private void scheduleSetDiagramSelection(final int tries, final Set<?> data) {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.ctx.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DiagramSelectionUpdater.this.setDiagramSelectionToData(tries, data);
            }
        });
    }

    private void setDiagramSelectionToData(final int tries, final Set<?> data) {
        DataElementMap dem = (DataElementMap)this.diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (dem != null) {
            ArrayList<IElement> newSelection = new ArrayList<IElement>(data.size());
            for (Object datum : data) {
                IElement element = dem.getElement(this.diagram, datum);
                if (element != null) {
                    newSelection.add(element);
                    continue;
                }
                if (tries <= 0) continue;
                ThreadUtils.asyncExec((IThreadWorkQueue)this.ctx.getThreadAccess(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DiagramSelectionUpdater.this.setDiagramSelectionToData(tries - 1, data);
                    }
                });
                return;
            }
            if (!newSelection.isEmpty()) {
                this.selection.setSelection(this.selectionId, newSelection);
            }
        }
    }
}

