/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

public class ElementReorder
extends ModificationAdapter {
    IDiagram diagram;
    List<IElement> order;

    public ElementReorder(IDiagram diagram, List<IElement> order) {
        super(LOW_PRIORITY);
        this.diagram = diagram;
        this.order = order;
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        Resource l = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        List graphOrder = OrderedSetUtils.toList((ReadGraph)g, (Resource)l);
        HashSet graphContents = new HashSet(graphOrder);
        ArrayList<Resource> diagramOrder = new ArrayList<Resource>(this.order.size());
        HashMap<Resource, Integer> diagramOrderIndex = new HashMap<Resource, Integer>(this.order.size());
        int i = 0;
        for (IElement e : this.order) {
            Resource r;
            Object obj = ElementUtils.getObject((IElement)e);
            if (!(obj instanceof Resource) || !graphContents.contains(r = (Resource)obj)) continue;
            diagramOrder.add(r);
            diagramOrderIndex.put(r, i);
            ++i;
        }
        i = 0;
        for (Resource r : graphOrder) {
            int targetIndex;
            int graphIndex;
            Integer di = (Integer)diagramOrderIndex.get(r);
            if (di == null || (graphIndex = i++) == (targetIndex = di.intValue())) continue;
            Resource graphPrev = OrderedSetUtils.prev((ReadGraph)g, (Resource)l, (Resource)r);
            Resource after = null;
            if (targetIndex == 0) {
                after = l;
                if (l.equals(graphPrev)) {
                    continue;
                }
            } else {
                after = (Resource)diagramOrder.get(targetIndex - 1);
                if (after.equals(graphPrev)) continue;
            }
            OrderedSetUtils.remove((WriteGraph)g, (Resource)l, (Resource)r);
            OrderedSetUtils.addAfter((WriteGraph)g, (Resource)l, (Resource)after, (Resource)r);
        }
    }
}

