/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.handler.MouseScaleMode;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;

public class SimpleElementTransformHandler
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    protected Selection selection;
    @DependencyReflection.Dependency
    protected MouseUtil mouseUtil;
    protected final boolean rotation;
    protected final boolean flip;
    protected final boolean scale;

    public SimpleElementTransformHandler() {
        this(true, true, false);
    }

    public SimpleElementTransformHandler(boolean enableRotation, boolean enableFlip, boolean enableScale) {
        this.rotation = enableRotation;
        this.flip = enableFlip;
        this.scale = enableScale;
    }

    public boolean isRotateEnabled() {
        return this.rotation;
    }

    public boolean isFlipEnabled() {
        return this.flip;
    }

    public boolean isScaleEnabled() {
        return this.scale;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent ke) {
        if (this.isRotateEnabled() && (ke.command.equals((Object)Commands.ROTATE_ELEMENT_CCW) || ke.command.equals((Object)Commands.ROTATE_ELEMENT_CW))) {
            return this.rotate(ke.command.equals((Object)Commands.ROTATE_ELEMENT_CW));
        }
        if (this.isFlipEnabled() && (ke.command.equals((Object)Commands.FLIP_ELEMENT_HORIZONTAL) || ke.command.equals((Object)Commands.FLIP_ELEMENT_VERTICAL))) {
            return this.flip(ke.command.equals((Object)Commands.FLIP_ELEMENT_VERTICAL));
        }
        if (this.isScaleEnabled() && Commands.SCALE_ELEMENT.equals((Object)ke.command)) {
            return this.startSelectionMouseScale(0);
        }
        return false;
    }

    private boolean flip(boolean xAxis) {
        Resource[] elements = this.getSelection();
        if (elements.length == 0) {
            return false;
        }
        ElementTransforms.flip(elements, xAxis);
        return true;
    }

    private boolean rotate(boolean clockwise) {
        Resource[] elements = this.getSelection();
        if (elements.length == 0) {
            return false;
        }
        ElementTransforms.rotate(elements, clockwise);
        return true;
    }

    protected Resource[] getSelection() {
        Set els = this.selection.getSelection(0);
        final HashSet<Resource> resources = new HashSet<Resource>();
        for (IElement el : els) {
            Object o = el.getHint(ElementHints.KEY_OBJECT);
            if (!(o instanceof Resource)) continue;
            resources.add((Resource)o);
        }
        try {
            return (Resource[])SimanticsUI.getSession().syncRequest((Read)new Read<Resource[]>(){

                public Resource[] perform(ReadGraph graph) throws DatabaseException {
                    List<Resource> result = SimpleElementTransformHandler.this.getSelection(graph, resources);
                    return result.toArray(new Resource[result.size()]);
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return Resource.NONE;
        }
    }

    protected List<Resource> getSelection(ReadGraph graph, Set<Resource> resources) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : resources) {
            if (!graph.isInstanceOf(r, dr.Element)) continue;
            result.add(r);
        }
        return result;
    }

    protected MouseScaleMode createMouseScaleMode(int mouseId, MouseUtil.MouseInfo mi, Set<IElement> s) {
        return new MouseScaleMode(mouseId, mi, s);
    }

    boolean startSelectionMouseScale(int mouseId) {
        Set s = this.selection.getSelection(mouseId);
        if (s.isEmpty()) {
            return false;
        }
        for (MouseScaleMode msm : this.getContext().getItemsByClass(MouseScaleMode.class)) {
            if (msm.getMouseId() != mouseId) continue;
            return false;
        }
        MouseUtil.MouseInfo mi = this.mouseUtil.getMouseInfo(mouseId);
        this.getContext().add((Object)this.createMouseScaleMode(mouseId, mi, s));
        return true;
    }

    void scaleAllSelections(DiagramMutator mutator, double xscale, double yscale) {
        for (Set s : this.selection.getSelections().values()) {
            for (IElement e : s) {
                Scale scale = (Scale)e.getElementClass().getAtMostOneItemOfClass(Scale.class);
                if (scale == null) continue;
                mutator.modifyTransform(e);
                Point2D sc = scale.getScale(e);
                sc.setLocation(xscale * sc.getX(), yscale * sc.getY());
                scale.setScale(e, sc);
            }
        }
    }

    void rotateAllSelections(DiagramMutator mutator, double degrees) {
        double angrad = Math.toRadians(degrees);
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        for (Set s : this.selection.getSelections().values()) {
            for (IElement e : s) {
                Rotate rotate = (Rotate)e.getElementClass().getAtMostOneItemOfClass(Rotate.class);
                if (rotate == null) continue;
                mutator.modifyTransform(e);
                rotate.rotate(e, angrad, (Point2D)origin);
            }
        }
    }
}

