/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.simantics.db.Session;
import org.simantics.db.common.SessionThread;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;

class QueryThread
extends Thread
implements SessionThread {
    boolean disposed = false;
    private Semaphore exited = new Semaphore(0);
    final int index;
    private Session session;
    private QuerySupport querySupport;
    private final ArrayList<QueryProcessor.SessionTask> tasks = new ArrayList();
    private final ArrayList<QueryProcessor.SessionTask> own;
    private final ArrayList<QueryProcessor.SessionTask> ownSync;
    private final ArrayList<QueryProcessor.SessionTask> queue;
    private final ReentrantLock lock;
    private final Condition condition;
    private final Object querySupportLock;
    private final int THREADS;
    private final AtomicInteger sleepers;
    private final QueryProcessor.ThreadState[] threadStates;
    private final ArrayList<QueryProcessor.SessionTask>[] delayQueues;
    private final QueryThread[] executors;
    private final ReentrantLock[] threadLocks;
    private final ArrayList<QueryProcessor.SessionTask>[] queues;
    private final ArrayList<QueryProcessor.SessionTask>[] ownSyncTasks;

    public QueryThread(Session session, QueryProcessor processor, int index, String name) {
        super(QueryProcessor.QueryThreadGroup, null, name);
        this.session = session;
        this.index = index;
        this.own = processor.ownTasks[index];
        this.ownSync = processor.ownSyncTasks[index];
        this.queue = processor.queues[index];
        this.lock = processor.threadLocks[index];
        this.condition = processor.threadConditions[index];
        this.querySupportLock = processor.querySupportLock;
        this.THREADS = processor.THREADS;
        this.sleepers = processor.sleepers;
        this.querySupport = processor.querySupport;
        this.threadStates = processor.threadStates;
        this.delayQueues = processor.delayQueues;
        this.executors = processor.executors;
        this.threadLocks = processor.threadLocks;
        this.queues = processor.queues;
        this.ownSyncTasks = processor.ownSyncTasks;
    }

    synchronized void dispose() {
        this.disposed = true;
        this.lock.lock();
        this.condition.signalAll();
        this.lock.unlock();
        try {
            this.exited.acquire();
        }
        catch (InterruptedException e) {
            Logger.defaultLogError((Throwable)e);
        }
        this.session = null;
        this.querySupport = null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ArrayList<QueryProcessor.SessionTask> newTasks(boolean doWait, ArrayList<QueryProcessor.SessionTask> tasks) {
        try {
            while (true) {
                if (tasks.addAll(this.own)) {
                    this.own.clear();
                } else if (doWait && !this.ownSync.isEmpty()) {
                    tasks.add(this.ownSync.remove(this.ownSync.size() - 1));
                }
                this.lock.lock();
                if (tasks.addAll(this.queue)) {
                    this.queue.clear();
                    this.lock.unlock();
                    return tasks;
                }
                this.lock.unlock();
                if (!tasks.isEmpty()) {
                    return tasks;
                }
                if (!doWait) {
                    return null;
                }
                Object object = this.querySupportLock;
                synchronized (object) {
                    this.lock.lock();
                    if (tasks.addAll(this.queue)) {
                        this.queue.clear();
                        this.lock.unlock();
                        return tasks;
                    }
                    if (this.sleepers.incrementAndGet() == this.THREADS) {
                        this.sleepers.decrementAndGet();
                        if (this.querySupport == null) {
                            System.err.println("null qs");
                        }
                        this.querySupport.ceased(this.index);
                        if (tasks.addAll(this.own)) {
                            this.own.clear();
                        }
                        if (!tasks.isEmpty()) {
                            this.lock.unlock();
                            return tasks;
                        }
                        this.sleepers.incrementAndGet();
                    }
                }
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    this.lock.unlock();
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.SLEEP;
                this.condition.await();
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    this.lock.unlock();
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.RUN;
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException("Querying was interrupted.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean runSynchronized() {
        didExecute = false;
        performer = 0;
        while (performer < this.THREADS) {
            if (!this.delayQueues[this.index * this.THREADS + performer].isEmpty()) {
                var3_5 = this.executors[performer];
                synchronized (var3_5) {
                    this.threadLocks[performer].lock();
                    this.queues[performer].addAll(this.delayQueues[this.index * this.THREADS + performer]);
                    this.delayQueues[this.index * this.THREADS + performer].clear();
                    this.executors[performer].notify();
                    this.threadLocks[performer].unlock();
                }
            }
            ++performer;
        }
        if (!this.tasks.isEmpty() || (finished = this.newTasks(false, this.tasks)) != null) ** GOTO lbl28
        return didExecute;
lbl-1000:
        // 1 sources

        {
            task = this.tasks.remove(this.tasks.size() - 1);
            if (task.syncCaller == this.index) {
                this.ownSyncTasks[this.index].add(task);
                continue;
            }
            task.run(this.index);
            didExecute = true;
lbl28:
            // 3 sources

            ** while (!this.tasks.isEmpty())
        }
lbl29:
        // 1 sources

        return didExecute;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

