/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.scl.ui.editor.SCLTextEditorNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.utils.ui.workbench.FocusContextActivator;

public class SCLTextEditor
extends LeafWidgetManager<SCLTextEditorNew> {
    @Override
    protected SCLTextEditorNew doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        SCLTextEditorNew editor = new SCLTextEditorNew(parent, 0);
        State state = new State(document, editor);
        editor.viewer.getTextWidget().setData("state", (Object)state);
        new FocusContextActivator("org.simantics.document.swt.core.widget.SCLTextEditor", (Control)editor.viewer.getTextWidget(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return editor;
    }

    @Override
    protected void doUpdateProperties(SWTDocument document, SCLTextEditorNew control, JSONObject object) {
        if (control.isDisposed()) {
            return;
        }
        TextAndErrors textAndErrors = (TextAndErrors)object.getValue("textAndErrors");
        if (textAndErrors == null) {
            return;
        }
        int caret = control.viewer.getTextWidget().getCaretOffset();
        control.setContent(textAndErrors.text, textAndErrors.errors);
        control.viewer.getTextWidget().setCaretOffset(caret);
        AbstractEventHandler onModify = (AbstractEventHandler)object.getValue("onModify");
        State state = (State)control.viewer.getTextWidget().getData("state");
        state.onModify = onModify;
    }

    public static class State {
        private final SWTDocument document;
        private final SCLTextEditorNew editor;
        public AbstractEventHandler onModify;

        public State(SWTDocument document, SCLTextEditorNew editor) {
            this.document = document;
            this.editor = editor;
        }

        public void fireText() {
            if (this.onModify != null) {
                CommandContextImpl parameters = new CommandContextImpl();
                parameters.putString("text", this.editor.getContent());
                this.document.post(this.onModify, (CommandContext)parameters);
            }
        }
    }
}

