/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;
import java.io.Serializable;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RoutePoint;

public class RouteLink
extends RoutePoint
implements Serializable {
    private static final long serialVersionUID = 1446230300676765986L;
    RouteLine a;
    RouteLine b;

    private RouteLink() {
    }

    RouteLink(RouteLine a, RouteLine b) {
        this.a = a;
        this.b = b;
        a.addPoint(this);
        b.addPoint(this);
    }

    @Override
    void removeFromOther(RouteLine other) {
        if (this.a == other) {
            this.b.points.remove(this);
        } else {
            this.a.points.remove(this);
        }
    }

    public RouteLine getA() {
        return this.a;
    }

    public RouteLine getB() {
        return this.b;
    }

    public void setA(RouteLine rl) {
        this.a = rl;
        rl.addPoint(this);
        if (this.b.isTransient()) {
            this.b.terminal.line = rl;
        }
    }

    public void setB(RouteLine rl) {
        this.b = rl;
        rl.addPoint(this);
        if (this.a.isTransient()) {
            this.a.terminal.line = rl;
        }
    }

    public RouteLine getOther(RouteLine line) {
        if (this.a == line) {
            return this.b;
        }
        return this.a;
    }

    public void replace(RouteLine rl1, RouteLine rl2) {
        if (this.a == rl1) {
            this.setA(rl2);
        } else if (this.b == rl1) {
            this.setB(rl2);
        }
    }

    @Override
    RouteLink copy(THashMap<Object, Object> map) {
        RouteLink copy = (RouteLink)map.get((Object)this);
        if (copy == null) {
            copy = new RouteLink();
            map.put((Object)this, (Object)copy);
            copy.a = this.a.copy(map);
            copy.b = this.b.copy(map);
            copy.x = this.x;
            copy.y = this.y;
        }
        return copy;
    }
}

