/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.simantics.scl.rest.ReadProgressInterceptor;
import org.simantics.scl.rest.WriteProgressInterceptor;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class HttpClientUtils {
    public static Client buildClient(ClientBuilder clientBuilder) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        return clientBuilder.withConfig((Configuration)clientConfig).build();
    }

    public static String statusMessageOf(Response response) {
        return response.getStatusInfo().getReasonPhrase();
    }

    public static Future<Response> asyncInvoke(Invocation invocation, final Function1<Response, Tuple0> responseCallback, final Function1<Throwable, Tuple0> failureCallback) {
        final SCLContext context = SCLContext.createDerivedContext();
        return invocation.submit((InvocationCallback)new InvocationCallback<Response>(){

            public void completed(Response response) {
                SCLContext.push((SCLContext)context);
                try {
                    responseCallback.apply((Object)response);
                }
                finally {
                    SCLContext.pop();
                }
            }

            public void failed(Throwable throwable) {
                SCLContext.push((SCLContext)context);
                try {
                    failureCallback.apply((Object)throwable);
                }
                finally {
                    SCLContext.pop();
                }
            }
        });
    }

    public static ClientBuilder trustAllClientBuilder() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return ClientBuilder.newBuilder().sslContext(sc).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public static void onWriteProgress(WebTarget target, Function1<Long, Tuple0> callback) {
        target.register((Object)new WriteProgressInterceptor(callback));
    }

    public static void onReadProgress(WebTarget target, Function1<Long, Tuple0> callback) {
        target.register((Object)new ReadProgressInterceptor(callback));
    }

    public static Long possibleContentLengthOf(Response response) {
        String lengthStr = response.getHeaderString("Content-Length");
        if (lengthStr != null) {
            try {
                return Long.parseLong(lengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }
}

