/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableFactory;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class StringArrayCells
implements VariableFactory {
    private Resource configuration;
    final String[] propertyNames = new String[]{"HasLabel", "immutable"};
    final Binding[] bindings = new Binding[]{Bindings.STRING, Bindings.BOOLEAN};

    public StringArrayCells(Resource configuration) {
        this.configuration = configuration;
    }

    private Collection<Variable> toVariables(ReadGraph graph, Variable variable, String[] data, int width) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        String location = (String)graph.getPossibleRelatedValue(this.configuration, sr.HasLocation, (Binding)Bindings.STRING);
        if (location == null) {
            return Collections.emptyList();
        }
        int rows = data.length / width;
        ArrayList<Variable> result = new ArrayList<Variable>();
        int offset = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < width) {
                String value = data[offset++];
                String valueLocation = SpreadsheetUtils.offset((String)location, (int)i, (int)j);
                result.add((Variable)new ConstantChildVariable(variable, valueLocation, this.propertyNames, this.bindings, new Object[]{value, true}));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Collection<Variable> error(ReadGraph graph, Variable variable, String message) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        String location = (String)graph.getPossibleRelatedValue(this.configuration, sr.HasLocation, (Binding)Bindings.STRING);
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ConstantChildVariable(variable, location, this.propertyNames, this.bindings, new Object[]{message}));
    }

    public Collection<Variable> evaluate(ReadGraph graph, Variable variable) throws DatabaseException {
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        String[] data = (String[])graph.getPossibleRelatedValue(this.configuration, sr.StringArrayCell_HasStringArray, (Binding)Bindings.STRING_ARRAY);
        if (data == null) {
            return this.error(graph, variable, "No string array data.");
        }
        Integer width = (Integer)graph.getPossibleRelatedValue(this.configuration, sr.StringArrayCell_HasWidth, (Binding)Bindings.INTEGER);
        if (width == null) {
            return this.error(graph, variable, "Invalid width for string array.");
        }
        return this.toVariables(graph, variable, data, width);
    }
}

