/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetElement;
import org.simantics.spreadsheet.graph.SpreadsheetVisitor;

public final class SpreadsheetStyle
implements SheetNode,
SpreadsheetElement<SpreadsheetStyle, SpreadsheetStyle> {
    private static final SpreadsheetStyle EMPTY = SpreadsheetStyle.newInstace().name("Style_E").build();
    private static final long serialVersionUID = -4969920277489585741L;
    public final String name;
    public final int border;
    public final int align;
    public final Font font;
    public final RGB.Integer foreground;
    public final RGB.Integer background;
    public final boolean locked;
    public final int rowSpan;
    public final int columnSpan;
    private transient int synchronizationId;
    private final transient int hashCode;
    public final String formatString;
    public final int formatIndex;

    public SpreadsheetStyle(String name, int border, int align2, Font font2, RGB.Integer foreground2, RGB.Integer background2, boolean locked2, int rowSpan2, int columnSpan2, String formatString, short formatIndex) {
        this.name = name;
        this.border = border;
        this.align = align2;
        this.font = font2;
        this.foreground = foreground2;
        this.background = background2;
        this.locked = locked2;
        this.rowSpan = rowSpan2;
        this.columnSpan = columnSpan2;
        this.formatString = formatString;
        this.formatIndex = formatIndex;
        this.hashCode = this.hashCode();
    }

    public int getId() {
        return this.synchronizationId;
    }

    public int getStyleId() {
        return this.hashCode();
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
    }

    @Override
    public Optional<SpreadsheetStyle> getParent() {
        return Optional.empty();
    }

    @Override
    public Collection<SpreadsheetStyle> getSpreadsheetChildren() {
        return Collections.emptyList();
    }

    @Override
    public void remove(SpreadsheetStyle child) {
    }

    @Override
    public String getName() {
        return "style";
    }

    public Map<?, ?> getChildren() {
        return Collections.emptyMap();
    }

    public Map<?, ?> getProperties() {
        return Collections.emptyMap();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.formatString == null ? 0 : this.formatString.hashCode());
        result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
        result = 31 * result + this.border;
        result = 31 * result + this.formatIndex;
        result = 31 * result + this.columnSpan;
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
        result = 31 * result + (this.locked ? 1231 : 1237);
        result = 31 * result + this.rowSpan;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetStyle other = (SpreadsheetStyle)obj;
        if (this.align != other.align) {
            return false;
        }
        if (this.background == null ? other.background != null : !this.background.equals((Object)other.background)) {
            return false;
        }
        if (this.border != other.border) {
            return false;
        }
        if (this.columnSpan != other.columnSpan) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals((Object)other.font)) {
            return false;
        }
        if (this.foreground == null ? other.foreground != null : !this.foreground.equals((Object)other.foreground)) {
            return false;
        }
        if (this.locked != other.locked) {
            return false;
        }
        if (this.rowSpan != other.rowSpan) {
            return false;
        }
        if (this.synchronizationId != other.synchronizationId) {
            return false;
        }
        if (this.formatIndex != other.formatIndex) {
            return false;
        }
        return !(this.formatString == null ? other.formatString != null : !this.formatString.equals(other.formatString));
    }

    public static SpreadsheetStyleBuilder newInstace() {
        return new SpreadsheetStyleBuilder();
    }

    public static SpreadsheetStyle empty() {
        return EMPTY;
    }

    public void setSynchronizationId(int newId) {
        this.synchronizationId = newId;
    }

    public static class SpreadsheetStyleBuilder {
        private String name;
        private RGB.Integer foreground;
        private RGB.Integer background;
        private int border;
        private int align;
        private Font font;
        private boolean locked;
        private int rowSpan = 1;
        private int columnSpan = 1;
        private String formatString;
        private short formatIndex;

        private SpreadsheetStyleBuilder() {
        }

        public SpreadsheetStyleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpreadsheetStyleBuilder foreground(RGB.Integer foreground) {
            this.foreground = foreground;
            return this;
        }

        public SpreadsheetStyleBuilder background(RGB.Integer background) {
            this.background = background;
            return this;
        }

        public SpreadsheetStyleBuilder border(Integer border) {
            this.border = border == null ? 0 : border;
            return this;
        }

        public SpreadsheetStyleBuilder align(Integer align) {
            this.align = align == null ? 0 : align;
            return this;
        }

        public SpreadsheetStyleBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public SpreadsheetStyleBuilder locked(boolean locked) {
            this.locked = locked;
            return this;
        }

        public SpreadsheetStyleBuilder rowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        public SpreadsheetStyleBuilder font(int columnSpan) {
            this.columnSpan = columnSpan;
            return this;
        }

        public SpreadsheetStyle build() {
            SpreadsheetStyle style = new SpreadsheetStyle(this.name, this.border, this.align, this.font, this.foreground, this.background, this.locked, this.rowSpan, this.columnSpan, this.formatString, this.formatIndex);
            return style;
        }

        public SpreadsheetStyleBuilder formatString(String formatString) {
            this.formatString = formatString;
            return this;
        }

        public SpreadsheetStyleBuilder formatIndex(short formatIndex) {
            this.formatIndex = formatIndex;
            return this;
        }

        public SpreadsheetStyleBuilder columnSpan(int columnSpan2) {
            this.columnSpan = columnSpan2;
            return this;
        }
    }
}

