/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetCellContent;
import org.simantics.spreadsheet.graph.SpreadsheetCellEditable;
import org.simantics.spreadsheet.graph.SpreadsheetCellStyle;
import org.simantics.spreadsheet.graph.SpreadsheetElement;
import org.simantics.spreadsheet.graph.SpreadsheetEngine;
import org.simantics.spreadsheet.graph.SpreadsheetFormula;
import org.simantics.spreadsheet.graph.SpreadsheetLine;
import org.simantics.spreadsheet.graph.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.graph.SpreadsheetStyle;
import org.simantics.spreadsheet.graph.SpreadsheetTypeNode;
import org.simantics.spreadsheet.graph.SpreadsheetVisitor;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetCell
implements SpreadsheetElement,
SheetNode {
    private static final long serialVersionUID = 6616793596542239339L;
    public static SpreadsheetCell EMPTY = new SpreadsheetCell(null, -1);
    private boolean inProgress = false;
    private int iterations = 0;
    private final SpreadsheetLine line;
    private final int column;
    int style;
    Object content;
    private final Map<String, SheetNode> properties = this.createProperties();
    private static String[] keys;

    static {
        EMPTY.setContent("");
        EMPTY.setStyle(SpreadsheetStyle.empty().getStyleId());
        keys = new String[]{"typeURI", "content"};
    }

    public SpreadsheetCell(SpreadsheetLine line, int column) {
        this.line = line;
        this.column = column;
    }

    private Map<String, SheetNode> createProperties() {
        HashMap<String, SheetNode> p = new HashMap<String, SheetNode>();
        p.put("typeURI", new SpreadsheetTypeNode("http://www.simantics.org/Spreadsheet-1.2/Cell"));
        p.put("content", new SpreadsheetCellContent(this));
        p.put("style", new SpreadsheetCellStyle(this));
        p.put("editable", new SpreadsheetCellEditable(this));
        return p;
    }

    public boolean hasExpression() {
        return this.content instanceof SpreadsheetFormula || this.content instanceof SpreadsheetSCLConstant;
    }

    public void setContent(Object newContent) {
        this.content = newContent;
    }

    @Override
    public String getName() {
        return SpreadsheetUtils.cellName((int)this.line.row, (int)this.column);
    }

    public Map<?, ?> getChildren() {
        return Collections.emptyMap();
    }

    public Map<String, SheetNode> getProperties() {
        return this.properties;
    }

    public SpreadsheetBook getBook() {
        return this.line.getEngine().getBook();
    }

    public SpreadsheetEngine getEngine() {
        return this.line.getEngine();
    }

    public <T> T evaluate(SpreadsheetEvaluationEnvironment env) {
        return this.evaluate(env, null);
    }

    public <T> T evaluate(SpreadsheetEvaluationEnvironment env, CellValueVisitor caller) {
        if (caller != null) {
            caller.addReference(this.makeReferenceKey());
        }
        if (this.content instanceof SpreadsheetFormula) {
            SpreadsheetFormula f = (SpreadsheetFormula)this.content;
            if (f.result == null) {
                CellValueVisitor visitor = new CellValueVisitor(env, this);
                AstValue value = ((SpreadsheetFormula)this.content).value;
                if (this.inProgress) {
                    ++this.iterations;
                }
                if (!env.getBook().isIterationEnabled()) {
                    if (!this.inProgress) {
                        this.inProgress = true;
                        f.result = value.accept(visitor);
                    } else {
                        f.result = FormulaError2.CIRCULAR_REF.getString();
                    }
                } else if (this.iterations < env.iterationLimit) {
                    this.inProgress = true;
                    f.result = value.accept(visitor);
                } else if (f.result == null) {
                    f.result = 0.0;
                }
                env.getBook().registerReferences(this.makeReferenceKey(), visitor.getReferences());
            }
            this.inProgress = false;
            this.iterations = 0;
            return (T)f.result;
        }
        if (this.content instanceof SpreadsheetSCLConstant) {
            SpreadsheetSCLConstant sclConstant = (SpreadsheetSCLConstant)this.content;
            return (T)sclConstant.content;
        }
        this.inProgress = false;
        return (T)this.content;
    }

    public long makeReferenceKey() {
        SpreadsheetBook book = this.getBook();
        SpreadsheetEngine engine = this.getEngine();
        long engineIndex = book.getEngineIndex(engine);
        long row = this.line.row;
        long col = this.column;
        return (engineIndex << 40) + (row << 20) + col;
    }

    public void invalidate() {
        this.getEngine().rangeCache = null;
        if (this.content instanceof SpreadsheetFormula) {
            SpreadsheetFormula f = (SpreadsheetFormula)this.content;
            f.result = null;
        }
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public Optional<SpreadsheetElement> getParent() {
        return Optional.of(this.line);
    }

    public List<SpreadsheetElement> getSpreadsheetChildren() {
        return Collections.emptyList();
    }

    public void remove(SpreadsheetElement child) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetCell other = (SpreadsheetCell)obj;
        if (this.column != other.column) {
            return false;
        }
        return !(this.line == null ? other.line != null : !this.line.equals(other.line));
    }

    public void setStyle(int styleId) {
        this.style = styleId;
    }

    public int getStyle() {
        return this.style;
    }

    public Object getContent() {
        return this.content;
    }

    public static SpreadsheetCell empty(SpreadsheetLine line, int column) {
        SpreadsheetCell cell = new SpreadsheetCell(line, column);
        cell.setContent("");
        cell.setStyle(SpreadsheetStyle.empty().getStyleId());
        return cell;
    }
}

