/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.AsyncListenerSupport;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.SyncListenerSupport;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.single.SingleSetSyncListenerDelegate;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleURIVariable;
import org.simantics.db.layer0.request.VariableName;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.layer0.Layer0;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.SheetCommands;
import org.simantics.spreadsheet.event.model.RemoveCellHandler;
import org.simantics.spreadsheet.graph.CellValue;
import org.simantics.spreadsheet.graph.Cells;
import org.simantics.spreadsheet.graph.FilteredVariableProperties;
import org.simantics.spreadsheet.graph.Ranges;
import org.simantics.spreadsheet.graph.SaveSpreadsheetStateDialog;
import org.simantics.spreadsheet.graph.SheetLines;
import org.simantics.spreadsheet.graph.Sheets;
import org.simantics.spreadsheet.graph.Sources;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetSessionManager;
import org.simantics.spreadsheet.graph.SpreadsheetStates;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUI
implements Adaptable,
ListenerSupport,
AsyncListenerSupport,
SyncListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphUI.class);
    public static final boolean DEBUG = false;
    private final RequestProcessor processor;
    private CellEditor<Write> cellEditor;
    private Variable run;
    private ClientModel client;
    private Map<String, PropertyListener> listenerCache = new THashMap();
    private SessionEventListenerAdapter listener;
    private String currentSource;
    private boolean disposed;

    public GraphUI(RequestProcessor processor) {
        this.processor = processor;
    }

    public void addCell(ReadGraph graph, Pair<String, Variable> child, ClientModel client) throws DatabaseException {
        String childName = ((Variable)child.second).getName(graph);
        Boolean immutable = (Boolean)((Variable)child.second).getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
        if (immutable != null && immutable.booleanValue()) {
            Collection properties = ((Variable)child.second).getProperties(graph, "http://www.simantics.org/Spreadsheet-1.2/Attribute");
            this.addProperties(graph, properties, client, childName);
        } else {
            PropertyListener listener = this.listenerCache.get(child.first);
            if (listener == null) {
                listener = this.propertyListener(client, childName);
                this.listenerCache.put((String)child.first, listener);
            }
            graph.asyncRequest((Read)new FilteredVariableProperties((Variable)child.second), (AsyncListener)listener);
        }
    }

    public void removeCell(ReadGraph graph, Pair<String, Variable> child, ClientModel client) throws DatabaseException {
        client.clear((String)child.first);
        PropertyListener listener = this.listenerCache.remove(child.first);
        if (listener != null) {
            listener.dispose();
        }
    }

    public void loadCells(ReadGraph graph, Variable container, boolean immutable, final ClientModel client) throws DatabaseException {
        if (immutable) {
            for (Pair cell : (Collection)graph.syncRequest((Read)new Cells(container), (AsyncProcedure)TransientCacheAsyncListener.instance())) {
                this.addCell(graph, (Pair<String, Variable>)cell, client);
            }
        } else {
            graph.syncRequest((Read)new Cells(container), (AsyncProcedure)new SingleSetSyncListenerDelegate<Pair<String, Variable>>((AsyncListenerSupport)this){

                public void add(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.addCell(graph, child, client);
                }

                public void remove(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.removeCell(graph, child, client);
                }
            });
        }
    }

    public Resource load(final Variable variable, final ClientModel client) throws DatabaseException {
        assert (variable != null);
        this.run = variable;
        this.client = client;
        SessionEventSupport support = (SessionEventSupport)this.processor.getService(SessionEventSupport.class);
        for (PropertyListener listener : this.listenerCache.values()) {
            listener.dispose();
        }
        this.listenerCache.clear();
        if (this.listener != null) {
            support.removeListener((SessionEventListener)this.listener);
        }
        this.listener = new SessionEventListenerAdapter(){

            public void writeTransactionFinished() {
                client.flush();
            }
        };
        support.addListener((SessionEventListener)this.listener);
        this.cellEditor = (CellEditor)this.processor.sync((ReadInterface)new VariableRead<CellEditor<Write>>(variable){

            public CellEditor<Write> perform(ReadGraph graph) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                return (CellEditor)this.variable.getPropertyValue(graph, SHEET.cellEditor);
            }
        });
        ITask task = ThreadLogger.getInstance().begin("GraphUI.init");
        client.clearAll();
        Map sources = (Map)this.processor.syncRequest((Read)new Sources(variable));
        List sheetList = (List)this.processor.syncRequest((Read)new Sheets(variable));
        String currentSheet = (String)this.processor.syncRequest((Read)new VariableName(variable));
        Map stateList = (Map)this.processor.syncRequest((Read)new SpreadsheetStates(variable));
        if (this.currentSource == null) {
            this.currentSource = "Sheet";
        }
        ArrayList sourceList = new ArrayList(sources.keySet());
        Collections.sort(sourceList, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        if (!sourceList.contains(this.currentSource)) {
            sourceList.add(this.currentSource);
        }
        client.setProperty("Sources", "available", (Object)sourceList.toArray(new String[sourceList.size()]));
        client.setProperty("Sources", "current", (Object)this.currentSource);
        client.setProperty("Sheets", "available", (Object)sheetList.toArray(new String[sheetList.size()]));
        client.setProperty("Sheets", "current", (Object)currentSheet);
        client.setProperty("States", "available", (Object)stateList.keySet().toArray(new String[stateList.size()]));
        client.setProperty("Context", "current", (Object)variable);
        client.setProperty("Mode", "current", (Object)ClientModel.OperationMode.OPERATION);
        String currentState = (String)this.processor.syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource book = variable.getParent(graph).getRepresents(graph);
                Resource ic = graph.getPossibleObject(book, SpreadsheetResource.getInstance((ReadGraph)graph).Book_HasDefaultInitialCondition);
                if (ic == null) {
                    return "";
                }
                return (String)graph.getRelatedValue2(ic, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
            }
        });
        client.setProperty("States", "current", (Object)currentState);
        this.processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphUI.this.loadCells(graph, variable, false, client);
                graph.syncRequest((Read)new Ranges(variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Variable>((AsyncListenerSupport)GraphUI.this){

                    public void add(ReadGraph graph, Variable range) throws DatabaseException {
                        Boolean immutable = (Boolean)range.getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
                        GraphUI.this.loadCells(graph, range, immutable != null && immutable != false, client);
                    }

                    public void remove(ReadGraph graph, Variable range) throws DatabaseException {
                    }
                });
                graph.syncRequest((Read)new SheetLines(variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Variable>((AsyncListenerSupport)GraphUI.this){

                    public void add(ReadGraph graph, Variable range) throws DatabaseException {
                        Boolean immutable = (Boolean)range.getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
                        GraphUI.this.loadCells(graph, range, immutable != null && immutable != false, client);
                    }

                    public void remove(ReadGraph graph, Variable range) throws DatabaseException {
                    }
                });
            }
        });
        task.finish();
        client.flush();
        return null;
    }

    private PropertyListener propertyListener(ClientModel client, String childName) {
        return new PropertyListener(this, client, childName);
    }

    private void addProperties(ReadGraph graph, Collection<Variable> properties, ClientModel client, String childName) throws DatabaseException {
        for (Variable property : properties) {
            Boolean editable;
            String propertyName = property.getName(graph);
            Object value = property.getValue(graph);
            client.setProperty(childName, propertyName, value);
            String expression = (String)property.getPossiblePropertyValue(graph, "expression", (Binding)Bindings.STRING);
            if (expression != null) {
                client.setProperty(childName, String.valueOf(propertyName) + "#expression", (Object)expression);
            }
            if ((editable = (Boolean)property.getPossiblePropertyValue(graph, "editable", (Binding)Bindings.STRING)) == null) continue;
            client.setProperty(childName, String.valueOf(propertyName) + "#editable", (Object)editable);
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (Variable.class == clazz) {
            return (T)this.run;
        }
        if (RemoveCellHandler.class == clazz) {
            return (T)new RemoveCellHandler(){

                public void handle(final String location) {
                    GraphUI.this.processor.asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            Resource config;
                            Variable cellVariable = GraphUI.this.run.getPossibleChild(graph, location);
                            if (cellVariable != null && (config = (Resource)cellVariable.getPossiblePropertyValue(graph, "Represents")) != null) {
                                graph.asyncRequest((Write)new WriteRequest(){

                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                        graph.deny(config, l0.PartOf);
                                    }
                                });
                            }
                        }
                    });
                }
            };
        }
        if (CellEditor.class == clazz) {
            return (T)new CellEditor<Write>(){

                public <E> void edit(CellEditor.Transaction<Write> transaction, String location, String property, final E value, Binding binding, Consumer<?> callback) {
                    if ("iterationEnabled".equals(location)) {
                        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph graph) throws DatabaseException {
                                GraphUI.this.getBook(graph).setIterationEnabled((Boolean)value);
                            }
                        });
                        return;
                    }
                    if ("Mode".equals(location) && "current".equals(property)) {
                        GraphUI.this.client.setProperty(location, property, value);
                        GraphUI.this.client.flush();
                        return;
                    }
                    if ("Context".equals(location) && "current".equals(property) && value instanceof String) {
                        try {
                            Variable newContext = (Variable)GraphUI.this.processor.syncRequest((Read)new UnaryRead<String, Variable>((String)value){

                                public Variable perform(ReadGraph graph) throws DatabaseException {
                                    String sheetName = GraphUI.this.run.getName(graph);
                                    Variable book = Variables.getContext((ReadGraph)graph, (Variable)GraphUI.this.run);
                                    Resource bookResource = book.getRepresents(graph);
                                    Variable input = Variables.getVariable((ReadGraph)graph, (String)((String)this.parameter));
                                    Variable proxy = ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)Variables.getVariable((ReadGraph)graph, (Resource)bookResource), (Variable)input);
                                    return proxy.getChild(graph, sheetName);
                                }
                            });
                            GraphUI.this.load(newContext, GraphUI.this.client);
                            return;
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("edit failed for model key 'current'", (Throwable)e);
                        }
                    }
                    if ("Sheets".equals(location) && "current".equals(property) && value instanceof String) {
                        try {
                            Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new UnaryRead<String, Variable>((String)value){

                                public Variable perform(ReadGraph graph) throws DatabaseException {
                                    return GraphUI.this.run.getParent(graph).getChild(graph, (String)this.parameter);
                                }
                            });
                            GraphUI.this.load(newInput, GraphUI.this.client);
                            return;
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("edit failed for model key 'current'", (Throwable)e);
                        }
                    }
                    if ("States".equals(location) && "current".equals(property) && value instanceof String) {
                        final String parameter = (String)value;
                        try {
                            String uri = (String)GraphUI.this.processor.syncRequest((WriteResult)new WriteResultRequest<String>(){

                                public String perform(WriteGraph graph) throws DatabaseException {
                                    Map states = (Map)graph.syncRequest((Read)new SpreadsheetStates(GraphUI.this.run));
                                    Resource state = null;
                                    for (Map.Entry entry : states.entrySet()) {
                                        if (!((String)entry.getKey()).equals(parameter)) continue;
                                        state = (Resource)entry.getValue();
                                        break;
                                    }
                                    if (state != null) {
                                        Variable context = Variables.getContext((ReadGraph)graph, (Variable)GraphUI.this.run);
                                        Resource bookResource = context.getRepresents((ReadGraph)graph);
                                        SpreadsheetGraphUtils.setDefaultInitialConditionForBook(graph, bookResource, state);
                                        context.getURI((ReadGraph)graph);
                                        String sessionName = context.getParent((ReadGraph)graph).getURI((ReadGraph)graph);
                                        SpreadsheetSessionManager.getInstance().removeRealm(graph, sessionName);
                                        SpreadsheetSessionManager.getInstance().getOrCreateRealm((ReadGraph)graph, sessionName);
                                    }
                                    return GraphUI.this.run.getURI((ReadGraph)graph);
                                }
                            });
                            Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new PossibleURIVariable(uri));
                            GraphUI.this.load(newInput, GraphUI.this.client);
                            return;
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("edit failed for model key 'current'", (Throwable)e);
                        }
                    }
                    if ("Sources".equals(location)) {
                        if ("current".equals(property)) {
                            try {
                                Resource res = WorkbenchSelectionUtils.getPossibleResource(value);
                                if (res != null) {
                                    Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new ResourceRead<Variable>(res){

                                        public Variable perform(ReadGraph graph) throws DatabaseException {
                                            Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)GraphUI.this.run);
                                            Variable in = Variables.getVariable((ReadGraph)graph, (Resource)this.resource);
                                            GraphUI.this.currentSource = in.getURI(graph);
                                            return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)base, (Variable)in);
                                        }
                                    });
                                    GraphUI.this.load(newInput, GraphUI.this.client);
                                    return;
                                }
                                if (value instanceof String) {
                                    Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new UnaryRead<String, Variable>((String)value){

                                        public Variable perform(ReadGraph graph) throws DatabaseException {
                                            Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)GraphUI.this.run);
                                            Map sources = (Map)graph.syncRequest((Read)new Sources(base));
                                            Variable found = (Variable)sources.get(this.parameter);
                                            if (found == null) {
                                                return null;
                                            }
                                            GraphUI.this.currentSource = (String)this.parameter;
                                            return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)base, (Variable)found);
                                        }
                                    });
                                    GraphUI.this.load(newInput, GraphUI.this.client);
                                    return;
                                }
                            }
                            catch (DatabaseException e) {
                                LOGGER.error("edit failed for model key 'current'", (Throwable)e);
                            }
                        }
                        return;
                    }
                    boolean needsCommit = false;
                    if (transaction == null) {
                        ClientModel.OperationMode mode = (ClientModel.OperationMode)GraphUI.this.client.getPropertyAt("Mode", "current");
                        transaction = this.startTransaction(mode);
                        transaction.setContext((Object)GraphUI.this.run);
                        needsCommit = true;
                    }
                    final CellEditor.Transaction<Write> finalTransaction = transaction;
                    GraphUI.this.cellEditor.edit(transaction, location, property, value, binding, (Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object param) {
                            if (finalTransaction.needSynchronization() != null) {
                                GraphUI.this.synchronize(finalTransaction.needSynchronization());
                            }
                        }
                    });
                    if (needsCommit) {
                        transaction.commit();
                    }
                }

                public void edit(CellEditor.Transaction<Write> transaction, String location, Variant variant, Consumer<?> callback) {
                    boolean needsCommit = false;
                    if (transaction == null) {
                        ClientModel.OperationMode mode = (ClientModel.OperationMode)GraphUI.this.client.getPropertyAt("Mode", "current");
                        transaction = this.startTransaction(mode);
                        transaction.setContext((Object)GraphUI.this.run);
                        needsCommit = true;
                    }
                    final CellEditor.Transaction<Write> finalTransaction = transaction;
                    GraphUI.this.cellEditor.edit(transaction, location, variant, (Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object param) {
                            if (finalTransaction.needSynchronization() != null) {
                                GraphUI.this.synchronize(finalTransaction.needSynchronization());
                            }
                        }
                    });
                    if (needsCommit) {
                        transaction.commit();
                    }
                }

                public void copy(final CellEditor.Transaction<Write> transaction, String location, MutableVariant variant, Consumer<?> callback) {
                    GraphUI.this.cellEditor.edit(transaction, location, (Variant)variant, (Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object param) {
                            if (transaction.needSynchronization() != null) {
                                GraphUI.this.synchronize(transaction.needSynchronization());
                            }
                        }
                    });
                }

                public CellEditor.Transaction<Write> startTransaction(ClientModel.OperationMode mode) {
                    return GraphUI.this.cellEditor.startTransaction(mode);
                }
            };
        }
        if (SheetCommands.class == clazz) {
            return (T)new SheetCommands(){

                public void saveState() {
                    Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
                            Resource uiContextResource = GraphUI.this.run.getRepresents(graph);
                            Resource bookResource = Variables.getContext((ReadGraph)graph, (Variable)GraphUI.this.run).getRepresents(graph);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            String uiContextName = (String)graph.getRelatedValue2(uiContextResource, L0.HasName, (Binding)Bindings.STRING);
                            String bookName = (String)graph.getRelatedValue2(bookResource, L0.HasName, (Binding)Bindings.STRING);
                            UISynchronize synchronizer = (UISynchronize)context.get(UISynchronize.class);
                            synchronizer.asyncExec(() -> {
                                Pair[] pairs = new Pair[]{Pair.make((Object)uiContextName, (Object)uiContextResource), Pair.make((Object)bookName, (Object)bookResource)};
                                SaveSpreadsheetStateDialog dialog = new SaveSpreadsheetStateDialog((IWorkbenchSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite(), "Save Spreadsheet state", pairs);
                                if (dialog.open() == 0) {
                                    Object[] result = dialog.getSelection();
                                    if (result != null) {
                                        final Pair p = (Pair)result[0];
                                        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                                            public void perform(WriteGraph graph) throws DatabaseException {
                                                Variable parent = GraphUI.this.run.getParent((ReadGraph)graph);
                                                ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)parent);
                                                SpreadsheetGraphUtils.saveInitialCondition(graph, parent, (Resource)p.first, (String)p.second);
                                            }
                                        });
                                    }
                                } else {
                                    return;
                                }
                            });
                        }
                    });
                }
            };
        }
        return null;
    }

    public void exception(Throwable t) {
        t.printStackTrace();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        LOGGER.error("Failed to read properties.", t);
    }

    public void exception(ReadGraph graph, Throwable t) {
        LOGGER.error("Failed to read properties.", t);
    }

    public void dispose() {
        for (PropertyListener listener : this.listenerCache.values()) {
            listener.dispose();
        }
        this.listenerCache.clear();
        SessionEventSupport support = (SessionEventSupport)this.processor.getService(SessionEventSupport.class);
        support.removeListener((SessionEventListener)this.listener);
        this.disposed = true;
    }

    private void synchronize(List<Object> list) {
        Simantics.getSession().asyncRequest((Read)new FullSynchronizeBook(this.run, list));
    }

    private SpreadsheetBook getBook(ReadGraph graph) throws DatabaseException {
        String sessionName = this.run.getParent(graph).getParent(graph).getURI(graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        return book;
    }

    public static class FullSynchronizeBook
    extends ReadRequest {
        private final Variable run;
        private final List<Object> location;

        public FullSynchronizeBook(Variable run, List<Object> cellLocation) {
            this.run = run;
            this.location = cellLocation;
        }

        public void run(ReadGraph graph) throws DatabaseException {
            this.run.getURI(graph);
            String parentUri = this.run.getParent(graph).getURI(graph);
            System.err.println("Full sync for book " + parentUri);
            Resource sheetResource = this.run.getRepresents(graph);
            Variables.getVariable((ReadGraph)graph, (Resource)sheetResource);
            TObjectIntHashMap changes = null;
            if (this.location != null) {
                changes = new TObjectIntHashMap(this.location.size());
                for (Object loc : this.location) {
                    Variable var = (Variable)loc;
                    changes.put((Object)var, 1);
                }
            }
            SpreadsheetGraphUtils.partialSynchronization(graph, this.run.getParent(graph), (TObjectIntHashMap<Variable>)changes);
        }
    }

    private static class PropertyListener
    extends SingleSetSyncListenerDelegate<Pair<String, Variable>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(PropertyListener.class);
        private ClientModel client;
        private String childName;
        private boolean listenerDisposed;

        public PropertyListener(AsyncListenerSupport support, ClientModel client, String childName) {
            super(support);
            this.client = client;
            this.childName = childName;
        }

        public void add(ReadGraph graph, final Pair<String, Variable> property) throws DatabaseException {
            graph.asyncRequest((Read)new CellValue((Variable)property.second), (SyncListener)new SyncListener<Object>(){

                public void execute(ReadGraph graph, Object value) throws DatabaseException {
                    String propertyName = (String)property.first;
                    client.setProperty(childName, propertyName, value);
                }

                public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                    LOGGER.error("PropertyListener.exception", throwable);
                    String propertyName = (String)property.first;
                    if ("content".equals(propertyName)) {
                        String message;
                        if (throwable == null) {
                            throwable = new Exception();
                        }
                        if ((message = throwable.getMessage()) == null) {
                            message = throwable.toString();
                        }
                        client.setProperty(childName, propertyName, (Object)Variant.ofInstance((Object)message));
                    } else {
                        client.setProperty(childName, propertyName, null);
                    }
                }

                public boolean isDisposed() {
                    return listenerDisposed;
                }
            });
        }

        public void dispose() {
            this.listenerDisposed = true;
        }

        public String toString() {
            return String.valueOf(super.toString()) + ":" + this.childName;
        }
    }
}

