/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.db.Resource;
import org.simantics.jfreechart.ChartDropTarget;
import org.simantics.jfreechart.ChartPanel;
import org.simantics.jfreechart.ChartPanelHeader;
import org.simantics.jfreechart.ChartPanelSeparator;
import org.simantics.jfreechart.chart.ChartComposite;
import org.simantics.ui.dnd.LocalObjectTransfer;

public class ChartPanelElement
extends Composite {
    public static int CHART_MINIMUM_WIDTH = 300;
    public static int CHART_MINIMUM_HEIGHT = 200;
    private ChartPanel panel;
    private ChartComposite chartComposite;
    private Resource chartResource;
    private boolean minimized = false;

    public Resource getResource() {
        return this.chartResource;
    }

    public Object getLayoutData() {
        this.checkWidget();
        Object oldData = super.getLayoutData();
        if (oldData == null || !(oldData instanceof GridData)) {
            oldData = GridDataFactory.fillDefaults().create();
        }
        int size = this.panel.getElements().size();
        GridData data = (GridData)oldData;
        data.widthHint = CHART_MINIMUM_WIDTH;
        if (this.getResource() == null && size == 1) {
            data.grabExcessHorizontalSpace = true;
        } else if (this.getResource() == null && !this.panel.isVertical()) {
            data.grabExcessHorizontalSpace = false;
            data.widthHint = -1;
        } else if (this.minimized && !this.panel.isVertical()) {
            data.grabExcessHorizontalSpace = false;
            data.widthHint = -1;
        } else {
            data.grabExcessHorizontalSpace = true;
        }
        if (this.getResource() == null && size == 1) {
            data.grabExcessVerticalSpace = true;
        } else if (!this.minimized && this.getResource() != null) {
            data.grabExcessVerticalSpace = true;
            data.heightHint = CHART_MINIMUM_HEIGHT;
        } else if (!this.panel.isVertical()) {
            data.grabExcessVerticalSpace = true;
        } else {
            data.grabExcessVerticalSpace = false;
            data.heightHint = -1;
        }
        return data;
    }

    public ChartPanelElement(Composite parent, ChartPanel panel, Resource chartResource, int style) {
        this(parent, panel, chartResource, false, style);
    }

    public ChartPanelElement(Composite parent, ChartPanel panel, Resource chartResource, boolean minimized, int style) {
        super(parent, style);
        this.panel = panel;
        this.chartResource = chartResource;
        this.minimized = minimized;
        if (panel.isVertical() || this.getResource() == null) {
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        }
        GridDataFactory.fillDefaults().applyTo((Control)this);
        ChartPanelSeparator separator = new ChartPanelSeparator(this, panel, this, 0);
        if (chartResource != null) {
            Composite c = new Composite((Composite)this, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(c);
            new ChartPanelHeader(c, this, chartResource, 2048);
            this.chartComposite = new ChartComposite(c, chartResource, 2048);
        }
        DropTarget target = new DropTarget((Control)this, 3);
        target.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new ChartDropTarget(separator, this, panel));
    }

    public Resource getChartResource() {
        return this.chartResource;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void toggleMinimize() {
        this.toggleMinimize(false);
    }

    public void toggleMinimize(boolean callSave) {
        this.minimized = Boolean.FALSE.equals(this.minimized);
        GridData data = (GridData)this.chartComposite.getLayoutData();
        data.exclude = this.panel.isVertical() ? this.minimized : false;
        this.chartComposite.setVisible(!this.minimized);
        Composite parent = this.getParent();
        data = (GridData)this.getLayoutData();
        GridData parentData = (GridData)parent.getLayoutData();
        parentData.grabExcessHorizontalSpace = data.grabExcessHorizontalSpace;
        parentData.grabExcessVerticalSpace = data.grabExcessVerticalSpace;
        parentData.heightHint = data.heightHint;
        if (callSave) {
            this.panel.saveState();
        }
        this.panel.layout();
    }

    public void remove() {
        this.panel.removeChart(this.chartResource);
    }
}

