/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.db;

import java.io.IOException;
import org.cojen.classfile.TypeDesc;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.utils.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLFunctions.class);
    public static final String GRAPH = "graph";

    public static <T> T safeExec(Function f) {
        try {
            return (T)f.apply((Object)Tuple0.INSTANCE);
        }
        catch (Throwable t) {
            LOGGER.error("safeExec caught exception", t);
            return null;
        }
    }

    public static void asyncRead(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.createDerivedContext();
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    f.apply((Object)Tuple0.INSTANCE);
                }
                finally {
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T syncRead(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        Object graph = context.get((Object)GRAPH);
        if (graph != null) {
            return (T)f.apply((Object)Tuple0.INSTANCE);
        }
        return (T)Simantics.getSession().syncRequest(new Read<T>(){

            public T perform(ReadGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static void asyncWrite(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.createDerivedContext();
        if (Simantics.peekSession() != null) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SCLContext.push((SCLContext)context);
                    context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                    try {
                        f.apply((Object)Tuple0.INSTANCE);
                    }
                    finally {
                        SCLContext.pop();
                    }
                }
            });
        } else {
            LOGGER.warn("No session available for asynchronous write requests");
        }
    }

    public static <T> T syncWrite(final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        Object graph = context.get((Object)GRAPH);
        if (graph != null) {
            return (T)f.apply((Object)Tuple0.INSTANCE);
        }
        return (T)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<T>(){

            public T perform(WriteGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T delayedSyncWrite(final Function f) throws DatabaseException {
        SCLContext context = SCLContext.getCurrent();
        final DataContainer dc = new DataContainer(null);
        DelayedWriteRequest request = new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                SCLContext context = SCLContext.getCurrent();
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    dc.set(f.apply((Object)Tuple0.INSTANCE));
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        };
        Object graph = context.get((Object)GRAPH);
        if (graph != null) {
            if (!(graph instanceof WriteGraph)) throw new DatabaseException("Caller is inside a read transaction.");
            ((WriteGraph)graph).syncRequest((DelayedWrite)request);
            return (T)dc.get();
        } else {
            Simantics.getSession().syncRequest((DelayedWrite)request);
        }
        return (T)dc.get();
    }

    public static <T> T virtualSyncWriteMem(WriteGraph graph, String virtualGraphId, final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getMemoryPersistent(virtualGraphId);
        return (T)graph.syncRequest((WriteResult)new WriteResultRequest<T>(vg){

            public T perform(WriteGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T virtualSyncWriteWS(WriteGraph graph, String virtualGraphId, final Function f) throws DatabaseException {
        final SCLContext context = SCLContext.getCurrent();
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        VirtualGraph vg = vgs.getWorkspacePersistent(virtualGraphId);
        return (T)graph.syncRequest((WriteResult)new WriteResultRequest<T>(vg){

            public T perform(WriteGraph graph) throws DatabaseException {
                SCLContext.push((SCLContext)context);
                ReadGraph oldGraph = (ReadGraph)context.put((Object)SCLFunctions.GRAPH, (Object)graph);
                try {
                    Object object = f.apply((Object)Tuple0.INSTANCE);
                    return object;
                }
                finally {
                    context.put((Object)SCLFunctions.GRAPH, (Object)oldGraph);
                    SCLContext.pop();
                }
            }
        });
    }

    public static <T> T readValue(final String uri) throws DatabaseException {
        return (T)Simantics.getSession().syncRequest(new Read<T>(){

            public T perform(ReadGraph graph) throws DatabaseException {
                return Variables.getVariable((ReadGraph)graph, (String)uri).getValue(graph);
            }
        });
    }

    public static <T> void writeValue(final String uri, final T value) throws DatabaseException {
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Variables.getVariable((ReadGraph)graph, (String)uri).setValue(graph, value);
            }
        });
    }

    public static void activateOnce(Resource r) {
        ((IActivationManager)Simantics.getSession().getService(IActivationManager.class)).activateOnce(r);
    }

    public static void syncActivateOnce(WriteGraph graph, Resource r) throws DatabaseException {
        ((IActivationManager)graph.getService(IActivationManager.class)).activateOnce(graph, r);
    }

    public static Resource resourceFromId(ReadGraph graph, long id) throws DatabaseException, IOException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return ss.getResource(id);
    }

    public static void disableDependencies(WriteGraph graph) {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
    }

    public static void enableDependencies(WriteGraph graph) {
        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)false);
    }

    public static void collectClusters() {
        ((ClusterControl)Simantics.getSession().getService(ClusterControl.class)).collectClusters(Integer.MAX_VALUE);
    }

    public static Object unaryQuery(ReadGraph graph, Function1<Object, Object> fn, Object value) throws DatabaseException {
        return graph.syncRequest((Read)new SCLUnaryRead(fn, value));
    }

    public static Object unaryQueryCached(ReadGraph graph, Function1<Object, Object> fn, Object value) throws DatabaseException {
        return graph.syncRequest((Read)new SCLUnaryRead(fn, value), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    public static Object subquery(ReadGraph graph, Function q) throws DatabaseException {
        return graph.syncRequest((Read)new Subquery(q));
    }

    public static Object subqueryC(ReadGraph graph, Function q) throws DatabaseException {
        return graph.syncRequest((Read)new Subquery(q), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    public static void subqueryL(ReadGraph graph, Function query, final Function executeCallback, final Function1<Throwable, Tuple> exceptionCallback, final Function1<Tuple0, Boolean> isDisposedCallback) throws DatabaseException {
        graph.asyncRequest((Read)new Subquery(query), (SyncListener)new SyncListenerAdapter<Object>(){

            public void execute(ReadGraph graph, Object result) throws DatabaseException {
                Simantics.applySCLRead((ReadGraph)graph, (Function1)executeCallback, (Object)result);
            }

            public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
                Simantics.applySCLRead((ReadGraph)graph, (Function1)exceptionCallback, (Object)t);
            }

            public boolean isDisposed() {
                return (Boolean)isDisposedCallback.apply((Object)Tuple0.INSTANCE);
            }
        });
    }

    public static Object possibleFromDynamic(Type expectedType, String moduleName, Object value) {
        try {
            Failable failable = SCLOsgi.MODULE_REPOSITORY.getModule(moduleName);
            Module module = (Module)failable.getResult();
            RuntimeEnvironment env = SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(EnvironmentSpecification.of((String[])new String[]{moduleName, ""}), module.getParentClassLoader());
            JavaTypeTranslator tr = new JavaTypeTranslator(env.getEnvironment());
            TypeDesc desc = tr.toTypeDesc(expectedType);
            String className = desc.getFullName();
            Class clazz = env.getMutableClassLoader().loadClass(className);
            if (!clazz.isAssignableFrom(value.getClass())) {
                return null;
            }
        }
        catch (ClassNotFoundException | ImportFailureException throwable) {}
        return value;
    }

    public static void restrictQueries(ReadGraph graph, int amount, int step, int maxTimeInMs) {
        long duration;
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        long start = System.currentTimeMillis();
        do {
            int current;
            if ((current = qc.count()) < amount) {
                return;
            }
            qc.gc(graph, step);
        } while ((duration = System.currentTimeMillis() - start) <= (long)maxTimeInMs);
    }

    public static int countQueries(ReadGraph graph) {
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        return qc.count();
    }

    public static class SCLUnaryRead
    extends BinaryRead<Function1<Object, Object>, Object, Object> {
        public SCLUnaryRead(Function1<Object, Object> parameter1, Object parameter2) {
            super(parameter1, parameter2);
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            return Simantics.applySCLRead((ReadGraph)graph, (Function1)((Function1)this.parameter), (Object)this.parameter2);
        }
    }

    private static class Subquery
    extends UnaryRead<Function, Object> {
        public Subquery(Function q) {
            super((Object)q);
        }

        public Object perform(ReadGraph graph) throws DatabaseException {
            return Simantics.applySCLRead((ReadGraph)graph, (Function1)((Function1)this.parameter), (Object)Tuple0.INSTANCE);
        }
    }
}

