/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.literal;

import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;

public class GUID
extends Bean {
    public static final Binding BINDING = Bindings.getBindingUnchecked(GUID.class);
    public long mostSignificant;
    public long leastSignificant;

    public GUID(long mostSignificant, long leastSignificant) {
        super(BINDING);
        this.mostSignificant = mostSignificant;
        this.leastSignificant = leastSignificant;
    }

    public static GUID invalid() {
        return new GUID(0L, 0L);
    }

    public static GUID invalid2() {
        return new GUID(0L, 1L);
    }

    public boolean isInvalid() {
        return this.mostSignificant == 0L && this.leastSignificant == 0L;
    }

    public static GUID random() {
        UUID random = UUID.randomUUID();
        return new GUID(random.getMostSignificantBits(), random.getLeastSignificantBits());
    }

    public String indexString() {
        StringBuilder b = new StringBuilder();
        b.append(Long.toHexString(this.mostSignificant));
        b.append("_");
        b.append(Long.toHexString(this.leastSignificant));
        return b.toString();
    }

    public static GUID parseIndexString(String indexString) {
        String[] parts = indexString.split("_");
        if (parts.length != 2) {
            throw new IllegalArgumentException();
        }
        Long mostSignificant = GUID.parseUnsignedLong(parts[0].toUpperCase(), 16);
        Long leastSignificant = GUID.parseUnsignedLong(parts[1], 16);
        return new GUID(mostSignificant, leastSignificant);
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = Long.parseLong(s.substring(0, len - 1), radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s);
            }
            long result = first * (long)radix + (long)second;
            if (GUID.compareUnsigned(result, first) < 0) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return result;
        }
        throw new NumberFormatException("For input string: \"" + s + "\"");
    }

    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }
}

