/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fileimport.scl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.simantics.Simantics;
import org.simantics.databoard.util.Base64;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.fileimport.Activator;
import org.simantics.fileimport.FileImportService;
import org.simantics.fileimport.dropins.FileImportDropins;
import org.simantics.layer0.Layer0;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropinsSCL {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropinsSCL.class);

    public static void watchDropinsFolder() {
        FileImportDropins.watchDropinsFolder();
    }

    public static void unwatchDropinsFolder() {
        FileImportDropins.unwatchDropinsFolder();
    }

    public static void uploadToDropinsBase64(String base64, String fileName) {
        FileImportDropins.watchDropinsFolder();
        Path rootFolder = null;
        try {
            rootFolder = Activator.getDropinsFolder();
            Path newFile = rootFolder.resolve(fileName);
            if (Files.exists(newFile, new LinkOption[0])) {
                newFile = DropinsSCL.findFreshFileName(rootFolder, fileName);
            }
            byte[] bytes = Base64.decode((String)base64);
            FileUtils.writeFile((File)newFile.toFile(), (byte[])bytes);
        }
        catch (IOException e) {
            LOGGER.error("Could not upload base64 to file " + (rootFolder != null ? rootFolder.resolve(fileName).toAbsolutePath() : ""), (Throwable)e);
        }
    }

    private static Path findFreshFileName(Path root, String fileName) throws IOException {
        int ending = fileName.lastIndexOf(46);
        String glob = fileName;
        String suffix = "";
        if (ending > -1) {
            glob = fileName.substring(0, ending);
            suffix = fileName.substring(ending);
        }
        int i = 0;
        Throwable throwable = null;
        Object var7_8 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            Iterator<Path> iter = stream.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String newFileName = String.valueOf(glob) + "_" + i + suffix;
        return root.resolve(newFileName);
    }

    public static Map<String, Long> getUploadedFiles() throws DatabaseException {
        final Map<String, String> results = FileImportService.getPathsAndResources();
        Map result = (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<String, Long>>(){

            public Map<String, Long> perform(ReadGraph graph) throws DatabaseException {
                HashMap<String, Long> map = new HashMap<String, Long>();
                for (Map.Entry entry : results.entrySet()) {
                    String value = (String)entry.getValue();
                    Long id = Long.valueOf(value);
                    SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    try {
                        Resource r = ss.getResource(id.longValue());
                        String name = (String)graph.getRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasName);
                        map.put(name, id);
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                }
                return map;
            }
        });
        return result;
    }

    public static void removeFileForId(long id) {
        FileImportService.removeFileForResource(id, Optional.empty());
    }
}

