/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.db.common.NamedResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.DraftStatusBean;
import org.simantics.modeling.ui.sharedontology.wizard.ImportPlan;
import org.simantics.utils.ui.ErrorLogger;

public class SharedOntologyImportPage
extends WizardPage {
    String failure;
    ImportPlan importModel;
    Composite draft;
    Text importTarget;
    CCombo importLocation;
    List<NamedResource> models = Collections.emptyList();
    Label author;
    Label status;

    protected SharedOntologyImportPage(ImportPlan model) {
        super("Import Shared Library", "Define Import Location", null);
        this.importModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.draft = new Composite(container, 0);
        this.draft.setBackground(this.draft.getDisplay().getSystemColor(3));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.draft);
        GridLayoutFactory.swtDefaults().numColumns(0).margins(0, 0).applyTo(this.draft);
        Composite draft2 = new Composite(this.draft, 0);
        GridLayoutFactory.swtDefaults().applyTo(draft2);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)draft2);
        new Label(draft2, 0).setText("This library draft was not finished for publishing.");
        new Label(container, 0).setText("&Shared library file:");
        this.importLocation = new CCombo(container, 2048);
        this.importLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.importLocation);
        this.importLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SharedOntologyImportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Br&owse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SharedOntologyImportPage.this.getShell(), 4096);
                dialog.setText("Choose Shared Library to Import");
                String loc = SharedOntologyImportPage.this.importLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.sharedLibrary"});
                dialog.setFilterNames(new String[]{"Shared Library (*.sharedLibrary)"});
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                SharedOntologyImportPage.this.importLocation.setText(file);
                SharedOntologyImportPage.this.validatePage();
            }
        });
        this.author = new Label(container, 0);
        this.author.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.author);
        this.status = new Label(container, 0);
        this.status.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.status);
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        for (String path : this.importModel.recentLocations) {
            this.importLocation.add(path);
        }
        if (this.importLocation.getItemCount() > 0) {
            this.importLocation.select(0);
        }
    }

    void validatePage() {
        if (this.failure != null) {
            this.setErrorMessage(this.failure);
            this.setPageComplete(false);
            return;
        }
        String importLoc = this.importLocation.getText();
        if (importLoc.isEmpty()) {
            this.setMessage("Select file to import.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(importLoc);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage("Selected file is invalid.");
            this.setPageComplete(false);
            return;
        }
        this.importModel.importLocation = file;
        try {
            DataContainer container = DataContainers.readHeader((File)file);
            Variant draftStatus = (Variant)container.metadata.get(DraftStatusBean.EXTENSION_KEY);
            if (draftStatus != null) {
                GridLayoutFactory.swtDefaults().spacing(5, 5).applyTo(this.draft);
                this.draft.getParent().layout(true);
            } else {
                GridLayoutFactory.swtDefaults().numColumns(0).margins(0, 0).applyTo(this.draft);
                this.draft.getParent().layout(true);
            }
            Variant authorVariant = (Variant)container.metadata.get("author");
            Variant dateVariant = (Variant)container.metadata.get("date");
            if (authorVariant != null && dateVariant != null) {
                String auth = (String)authorVariant.getValue((Binding)Bindings.STRING);
                String date = (String)dateVariant.getValue((Binding)Bindings.STRING);
                this.author.setText("Created by " + auth + " on " + date);
            } else {
                this.author.setText("");
            }
        }
        catch (IOException iOException) {
            this.setErrorMessage("Could not read header information from " + file.getAbsolutePath());
            this.setPageComplete(false);
            return;
        }
        catch (AdaptException adaptException) {
            this.setErrorMessage("Could not read header information from " + file.getAbsolutePath());
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage("Ready to import " + file.getName());
        this.setPageComplete(true);
    }
}

