/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.ui.ISelectionUtils;

public class RestoreDefaultValueHandler
extends AbstractHandler {
    IPage getCurrentPage(IWorkbenchPart part) {
        if (part instanceof PageBookView) {
            return ((PageBookView)part).getCurrentPage();
        }
        if (part instanceof org.simantics.browsing.ui.platform.PageBookView) {
            return ((org.simantics.browsing.ui.platform.PageBookView)part).getCurrentPage();
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISessionContext sc = SimanticsUI.getSessionContext();
        if (sc == null) {
            return null;
        }
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        IPage page = this.getCurrentPage(part);
        if (page == null || !(page instanceof IPropertyPage)) {
            return null;
        }
        IPropertyPage propPage = (IPropertyPage)page;
        ISelection sel = propPage.getSelection();
        if (sel == null) {
            return null;
        }
        List vars = ISelectionUtils.filterSelection((ISelection)sel, Variable.class);
        if (!vars.isEmpty()) {
            this.resetVariableProperties(sc, vars);
        } else {
            List props = ISelectionUtils.filterSelection((ISelection)sel, IProperty.class);
            if (!props.isEmpty()) {
                this.resetLegacyProperties(sc, props);
            }
        }
        return null;
    }

    private void resetVariableProperties(ISessionContext sc, final List<Variable> vars) {
        sc.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                for (Variable v : vars) {
                    Resource parentResource;
                    Variable parent;
                    Resource predicateResource = v.getPossiblePredicateResource((ReadGraph)graph);
                    if (predicateResource == null || (parent = v.getParent((ReadGraph)graph)) == null || (parentResource = parent.getPossibleRepresents((ReadGraph)graph)) == null) continue;
                    graph.denyValue(parentResource, predicateResource);
                    cm.add("Restored default value for property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)predicateResource));
                }
                graph.addMetadata((Metadata)cm);
            }
        }, e -> {
            if (e != null) {
                ErrorLogger.defaultLogError((String)"Failed to restore default property values, see exception for details.", (Throwable)e);
            }
        });
    }

    private boolean resetLegacyProperties(ISessionContext sc, final List<IProperty> props) {
        boolean changes = false;
        for (IProperty cp : props) {
            if (!IProperty.DIRECT.contains(cp.getType())) continue;
            changes = true;
            break;
        }
        if (changes) {
            sc.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    for (IProperty cp : props) {
                        if (!IProperty.DIRECT.contains(cp.getType())) continue;
                        Resource[] data = (Resource[])cp.getData(Resource[].class);
                        graph.denyStatement(data[0], data[1], data[2]);
                    }
                }
            }, e -> {
                if (e != null) {
                    ErrorLogger.defaultLogError((String)"Failed to restore default property values, see exception for details.", (Throwable)e);
                }
            });
        }
        return changes;
    }
}

