/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.modeling.ui.modelBrowser.model.INode2;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class DeleteNodeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"execute");
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Set ctxs = ISelectionUtils.filterSetSelection((Object)sel, NodeContext.class);
        if (ctxs.isEmpty()) {
            return null;
        }
        if (ctxs.size() == 1 && this.handleLegacyDelete((NodeContext)ctxs.iterator().next())) {
            return null;
        }
        final Set deletableNodes = ISelectionUtils.filterSetSelection((Object)ctxs, IDeletableNode.class);
        if (!deletableNodes.isEmpty()) {
            if (deletableNodes.size() == ctxs.size()) {
                this.inJob(shell, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Delete selected nodes", -1);
                        try {
                            for (IDeletableNode deletableNode : deletableNodes) {
                                deletableNode.delete();
                            }
                        }
                        catch (DeleteException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        } else {
            final Set rs = ISelectionUtils.filterSetSelection((Object)ctxs, Resource.class);
            if (rs.size() == ctxs.size()) {
                this.inJob(shell, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Delete selected nodes", -1);
                        try {
                            RemoverUtil.tryCollectionRemover((Collection)rs);
                        }
                        catch (CannotRemoveException e) {
                            ShowMessage.showInformation((String)"Delete Selection Was Denied", (String)e.getLocalizedMessage());
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
        }
        TimeLogger.log((String)"Node deleted");
        return null;
    }

    private void inJob(Shell shell, IRunnableWithProgress runnable) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Delete failed, see exception for details.", e.getCause()));
        }
        catch (InterruptedException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Delete failed, see exception for details.", e.getCause()));
        }
    }

    private boolean handleLegacyDelete(NodeContext ctx) {
        if (ctx.getAdapter(IDeletable.class) == null) {
            return false;
        }
        final INode node = (INode)ctx.getAdapter(INode.class);
        if (node != null) {
            SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    node.handleDelete(graph);
                }
            });
            return true;
        }
        INode2 node2 = (INode2)ctx.getAdapter(INode2.class);
        if (node2 != null) {
            try {
                node2.handleDelete();
            }
            catch (DeleteException e) {
                ShowMessage.showError((String)"Delete failed", (String)e.getMessage());
                ErrorLogger.defaultLogError((Throwable)e);
            }
            return true;
        }
        return false;
    }
}

