/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class OpenDiagramFromConfigurationAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.modeling.ui.diagramEditor";

    public OpenDiagramFromConfigurationAdapter() {
        super("Diagram Editor", Activator.COMPOSITE_ICON);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        Resource diagram = OpenDiagramFromConfigurationAdapter.getDiagram(g, r, Collections.emptySet());
        if (diagram == null) {
            return false;
        }
        return !OpenDiagramFromConfigurationAdapter.isLocked(g, diagram);
    }

    public static boolean isLocked(ReadGraph g, Resource diagram) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        Resource componentType = (Resource)g.syncRequest((AsyncRead)new PossibleTypedParent(diagram, STR.ComponentType));
        if (componentType == null) {
            return false;
        }
        return g.hasStatement(componentType, STR.ComponentType_Locked);
    }

    public void openEditor(final Resource r) throws Exception {
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                OpenDiagramFromConfigurationAdapter.openEditor(g, r, OpenDiagramFromConfigurationAdapter.this.getEditorId());
            }
        });
    }

    public static boolean openEditor(ReadGraph g, Resource configurationComposite, String editorId) throws DatabaseException {
        return OpenDiagramFromConfigurationAdapter.openEditor(g, configurationComposite, editorId, Collections.emptySet());
    }

    protected static Resource getDiagram(ReadGraph graph, Resource r, Collection<Object> selectedObjects) throws DatabaseException {
        Resource res;
        Object o;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(r, DIA.Diagram)) {
            return r;
        }
        Resource diagram = ComponentUtils.getPossibleCompositeDiagram((ReadGraph)graph, (Resource)r);
        if (diagram != null) {
            return diagram;
        }
        if (selectedObjects.size() == 1 && (o = selectedObjects.iterator().next()) instanceof Resource && graph.isInstanceOf(res = (Resource)o, DIA.Element)) {
            return graph.getPossibleObject(res, L0.PartOf);
        }
        return null;
    }

    public static Pair<Resource, RVI> getModelAndRVI(ReadGraph graph, Resource configurationComposite) throws DatabaseException {
        Variable compositeVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)configurationComposite);
        if (compositeVariable == null) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        boolean isComponentType = graph.hasStatement(configurationComposite, STR.Defines);
        Resource rviContext = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(configurationComposite, L0.RVIContext));
        if (isComponentType || rviContext == null) {
            Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(configurationComposite));
            if (indexRoot == null) {
                return null;
            }
            return Pair.make((Object)indexRoot, null);
        }
        Resource model = Variables.getPossibleModel((ReadGraph)graph, (Variable)compositeVariable);
        if (model == null) {
            return null;
        }
        RVI rvi = compositeVariable.getPossibleRVI(graph);
        return Pair.make((Object)model, (Object)rvi);
    }

    public static boolean openEditor(ReadGraph g, Resource r, String editorId, Collection<Object> selectedObjects) throws DatabaseException {
        Pair<Resource, RVI> modelAndRVI;
        Resource diagram = OpenDiagramFromConfigurationAdapter.getDiagram(g, r, selectedObjects);
        Resource configurationComposite = diagram != null ? ComponentUtils.getPossibleDiagramComposite((ReadGraph)g, (Resource)diagram) : null;
        Pair<Resource, RVI> pair = modelAndRVI = configurationComposite != null ? OpenDiagramFromConfigurationAdapter.getModelAndRVI(g, configurationComposite) : null;
        if (modelAndRVI == null) {
            return false;
        }
        OpenDiagramFromConfigurationAdapter.scheduleOpenEditor(editorId, diagram, (Resource)modelAndRVI.first, (RVI)modelAndRVI.second, selectedObjects);
        return true;
    }

    public static boolean openEditor(ReadGraph g, Resource r, String editorId, Collection<Object> selectedObjects, Resource model, RVI rvi) throws DatabaseException {
        Resource diagram = OpenDiagramFromConfigurationAdapter.getDiagram(g, r, selectedObjects);
        if (diagram == null) {
            return false;
        }
        OpenDiagramFromConfigurationAdapter.scheduleOpenEditor(editorId, diagram, model, rvi, selectedObjects);
        return true;
    }

    private static void scheduleOpenEditor(String editorId, Resource diagram, Resource model, RVI rvi, Collection<Object> selectedObjects) throws DatabaseException {
        Runnable editorActivator = NavigateToTarget.editorActivator((String)editorId, (Resource)diagram, (Resource)model, (RVI)rvi, part -> {
            if (selectedObjects.isEmpty()) {
                return;
            }
            ICanvasContext openedCanvas = (ICanvasContext)part.getAdapter(ICanvasContext.class);
            assert (openedCanvas != null);
            openedCanvas.getDefaultHintContext().setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.FALSE);
            ThreadUtils.asyncExec((IThreadWorkQueue)openedCanvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer((ICanvasContext)openedCanvas, (Collection)selectedObjects, (boolean)false));
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(editorActivator);
    }
}

