/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import gnu.trove.map.hash.THashMap;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.graphviz.Record;
import org.simantics.graphviz.ui.GraphvizComponent;
import org.simantics.layer0.Layer0;
import org.simantics.structural2.Functions;
import org.simantics.structural2.procedural.Component;
import org.simantics.structural2.procedural.Connection;
import org.simantics.structural2.procedural.ConnectionPoint;
import org.simantics.structural2.procedural.Interface;
import org.simantics.structural2.procedural.Property;
import org.simantics.structural2.procedural.SubstructureElement;
import org.simantics.structural2.procedural.Terminal;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.datastructures.Pair;

public class ProceduralComponentInstanceViewer
extends ResourceEditorPart {
    GraphvizComponent graphviz;

    public void createPartControl(Composite parent) {
        this.graphviz = new GraphvizComponent(parent, 0);
        Simantics.getSession().asyncRequest((Read)new Read<Graph>(){

            public Graph perform(ReadGraph graph) throws DatabaseException {
                Resource inputResource = ProceduralComponentInstanceViewer.this.getInputResource();
                Variable context = Variables.getPossibleVariable((ReadGraph)graph, (Resource)inputResource);
                if (context == null) {
                    return ProceduralComponentInstanceViewer.createErrorGraph("Couldn't create variable for the resource.");
                }
                try {
                    List proceduralDesc = Functions.getProceduralDesc((ReadGraph)graph, (Variable)context);
                    if (proceduralDesc == null) {
                        return ProceduralComponentInstanceViewer.createErrorGraph("Component does not have a procedural substructure.");
                    }
                    return ProceduralComponentInstanceViewer.createGraph(graph, proceduralDesc);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return ProceduralComponentInstanceViewer.createErrorGraph(e.getMessage());
                }
            }
        }, (Listener)new Listener<Graph>(){

            public void execute(final Graph graph) {
                if (!ProceduralComponentInstanceViewer.this.graphviz.isDisposed()) {
                    ProceduralComponentInstanceViewer.this.graphviz.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ProceduralComponentInstanceViewer.this.graphviz.isDisposed()) {
                                return;
                            }
                            if (graph != null) {
                                (this).ProceduralComponentInstanceViewer.this.graphviz.setGraph(graph);
                            }
                        }
                    });
                }
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return ProceduralComponentInstanceViewer.this.graphviz.isDisposed();
            }
        });
    }

    public void setFocus() {
        this.graphviz.setFocus();
    }

    private static Graph createErrorGraph(String description) {
        Graph graph = new Graph();
        new Node((IGraph)graph, description).setShape("rectangle");
        return graph;
    }

    private static String nameOf(ReadGraph g, Resource r) throws DatabaseException {
        return (String)g.getRelatedValue(r, Layer0.getInstance((ReadGraph)g).HasName);
    }

    private static Pair<Node, String> getCp(ReadGraph g, Graph graph, THashMap<String, Node> components, THashMap<Resource, Node> connectionPoints, ConnectionPoint cp) throws DatabaseException {
        if (cp instanceof Terminal) {
            Terminal terminal = (Terminal)cp;
            return Pair.make((Object)((Node)components.get((Object)terminal.component)), (Object)ProceduralComponentInstanceViewer.nameOf(g, terminal.relation));
        }
        Interface interface_ = (Interface)cp;
        Node node = (Node)connectionPoints.get((Object)interface_.relation);
        if (node == null) {
            node = new Node((IGraph)graph);
            node.setShape("diamond");
            node.setLabel(ProceduralComponentInstanceViewer.nameOf(g, interface_.relation));
            connectionPoints.put((Object)interface_.relation, (Object)node);
        }
        return Pair.make((Object)node, null);
    }

    private static Graph createGraph(ReadGraph g, List<SubstructureElement> proceduralDesc) throws DatabaseException {
        Graph graph = new Graph();
        graph.setRankdir("LR");
        THashMap components = new THashMap();
        for (SubstructureElement element : proceduralDesc) {
            if (!(element instanceof Component)) continue;
            Component component = (Component)element;
            Record record = new Record();
            record.add(String.valueOf(component.name) + " : " + ProceduralComponentInstanceViewer.nameOf(g, component.type));
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Property property : component.properties) {
                if (first) {
                    first = false;
                } else {
                    b.append("\\n");
                }
                b.append(String.valueOf(ProceduralComponentInstanceViewer.nameOf(g, property.relation)) + " = " + property.value);
            }
            record.add(b.toString());
            components.put((Object)component.name, (Object)record.toNode(graph));
        }
        THashMap connectionPoints = new THashMap();
        for (SubstructureElement element : proceduralDesc) {
            if (!(element instanceof Connection)) continue;
            Connection connection = (Connection)element;
            List cps = connection.connectionPoints;
            if (cps.size() == 2) {
                Pair<Node, String> cp1 = ProceduralComponentInstanceViewer.getCp(g, graph, (THashMap<String, Node>)components, (THashMap<Resource, Node>)connectionPoints, (ConnectionPoint)cps.get(0));
                Pair<Node, String> cp2 = ProceduralComponentInstanceViewer.getCp(g, graph, (THashMap<String, Node>)components, (THashMap<Resource, Node>)connectionPoints, (ConnectionPoint)cps.get(1));
                Edge edge = new Edge((Identifiable)cp1.first, (Identifiable)cp2.first);
                if (cp1.second != null) {
                    if (cp2.second != null) {
                        edge.setLabel(String.valueOf((String)cp1.second) + "-" + (String)cp2.second);
                        continue;
                    }
                    edge.setLabel((String)cp1.second);
                    continue;
                }
                if (cp2.second == null) continue;
                edge.setLabel((String)cp2.second);
                continue;
            }
            Node p = new Node((IGraph)graph);
            p.setShape("point");
            boolean first = true;
            for (ConnectionPoint cp : cps) {
                Edge edge;
                Pair<Node, String> cp1 = ProceduralComponentInstanceViewer.getCp(g, graph, (THashMap<String, Node>)components, (THashMap<Resource, Node>)connectionPoints, cp);
                if (first) {
                    edge = new Edge((Identifiable)cp1.first, (Identifiable)p);
                    edge.setLabel((String)cp1.second);
                    first = false;
                    continue;
                }
                edge = new Edge((Identifiable)p, (Identifiable)cp1.first);
                edge.setLabel((String)cp1.second);
            }
        }
        return graph;
    }
}

