/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.TeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;

public class TeamContentProviderManager
implements ITeamContentProviderManager {
    public static final String PT_TEAM_CONTENT_PROVIDERS = "teamContentProviders";
    private static ITeamContentProviderManager instance;
    Map descriptors;
    private ListenerList listeners = new ListenerList(1);

    public static ITeamContentProviderManager getInstance() {
        if (instance == null) {
            instance = new TeamContentProviderManager();
        }
        return instance;
    }

    @Override
    public ITeamContentProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return this.descriptors.values().toArray(new ITeamContentProviderDescriptor[this.descriptors.size()]);
    }

    @Override
    public String[] getContentProviderIds(ISynchronizationScope scope) {
        ArrayList<String> result = new ArrayList<String>();
        ITeamContentProviderDescriptor[] descriptors = this.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            if (descriptor.isEnabled() && scope.getMappings(descriptor.getModelProviderId()).length > 0) {
                result.add(descriptor.getContentExtensionId());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public ITeamContentProviderDescriptor getDescriptor(String modelProviderId) {
        this.lazyInitialize();
        return (ITeamContentProviderDescriptor)this.descriptors.get(modelProviderId);
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.ui", PT_TEAM_CONTENT_PROVIDERS);
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap(extensions.length * 2);
        int i = 0;
        int imax = extensions.length;
        while (i < imax) {
            TeamContentProviderDescriptor desc = null;
            try {
                desc = new TeamContentProviderDescriptor(extensions[i]);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            if (desc != null) {
                this.descriptors.put(desc.getModelProviderId(), desc);
            }
            ++i;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void firePropertyChange(final PropertyChangeEvent event) {
        Object[] allListeners = this.listeners.getListeners();
        int i = 0;
        while (i < allListeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)allListeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.propertyChange(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    public void enablementChanged(ITeamContentProviderDescriptor[] oldEnabled, ITeamContentProviderDescriptor[] newEnabled) {
        this.firePropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS", (Object)oldEnabled, (Object)newEnabled));
    }

    @Override
    public void setEnabledDescriptors(ITeamContentProviderDescriptor[] descriptors) {
        ArrayList<TeamContentProviderDescriptor> previouslyEnabled = new ArrayList<TeamContentProviderDescriptor>();
        for (TeamContentProviderDescriptor descriptor : this.descriptors.values()) {
            if (!descriptor.isEnabled()) continue;
            previouslyEnabled.add(descriptor);
            descriptor.setEnabled(false);
        }
        int i = 0;
        while (i < descriptors.length) {
            TeamContentProviderDescriptor descriptor;
            descriptor = (TeamContentProviderDescriptor)descriptors[i];
            descriptor.setEnabled(true);
            ++i;
        }
        this.enablementChanged(previouslyEnabled.toArray(new ITeamContentProviderDescriptor[previouslyEnabled.size()]), descriptors);
    }
}

