/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.util.Collection;
import org.simantics.db.Resource;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.graph.db.ImportResult;

public class MigratedImportResult {
    public final Collection<Resource> roots;
    public final ImportResult tgResult;

    public MigratedImportResult(Collection<Resource> roots, ImportResult tgResult) {
        this.roots = roots;
        this.tgResult = tgResult;
    }

    public Resource singleRoot() throws DatabaseException {
        int s = this.roots.size();
        if (s != 1) {
            throw new AssumptionException("No single imported root found, roots are: " + this.roots);
        }
        return this.roots.iterator().next();
    }

    public boolean hasMissingExternals() {
        return this.tgResult != null ? this.tgResult.hasMissingExternals() : false;
    }
}

