/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.refactoring;

import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.store.IdentityStore;

public class TGRefactoring {
    public static void main(String[] args) throws Exception {
        File dir = new File(URLDecoder.decode(TGRefactoring.class.getResource(".").getPath(), "UTF-8")).getAbsoluteFile();
        System.out.println(dir);
        File input = new File(dir, "ServiceModel_2012-08-28b.tg");
        File mappingSpec = new File(dir, "mappingSpec.txt");
        File output = new File(dir, "ServiceModel_2012-08-28b-refactored.tg");
        DataContainer dc = DataContainers.readFile((File)input);
        TransferableGraph1 tg1 = (TransferableGraph1)dc.content.getValue(TransferableGraph1.BINDING);
        MappingSpecification spec = TGRefactoring.readMappingSpec(mappingSpec);
        boolean fixed = GraphRefactoringUtils.fixIncorrectRoot((Identity[])tg1.identities);
        IdentityStore idStore = TransferableGraphConversion.extractIdentities((TransferableGraph1)tg1);
        TIntHashSet parentsAffected = new TIntHashSet();
        GraphRefactoringUtils.refactor((TransferableGraph1)tg1, (IdentityStore)idStore, (MappingSpecification)spec, (TIntHashSet)parentsAffected);
        tg1.resourceCount = idStore.getResourceCount();
        tg1.identities = idStore.toArray();
        if (fixed) {
            GraphRefactoringUtils.unfixIncorrectRoot((Identity[])tg1.identities);
        }
        dc.content = new Variant(TransferableGraph1.BINDING, (Object)tg1);
        DataContainers.writeFile((File)output, (DataContainer)dc);
    }

    private static MappingSpecification readMappingSpec(File mappingSpec) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(mappingSpec));
        ArrayList<MappingSpecification.MappingRule> rules = new ArrayList<MappingSpecification.MappingRule>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] parts = line.trim().split(" ");
            if (parts.length == 2) {
                Path from = UriUtils.uriToPath((String)parts[0]);
                Path to = UriUtils.uriToPath((String)parts[1]);
                rules.add(new MappingSpecification.MappingRule(from, to));
                continue;
            }
            if (line.trim().startsWith("//") || line.trim().startsWith("/*") && line.trim().endsWith("/*")) continue;
            reader.close();
            throw new IOException("Invalid mapping spec format. Every non-empty line should contain two URIs or comment");
        }
        reader.close();
        return new MappingSpecification(rules);
    }
}

