/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model.expression;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.expression.Expression;

public class LookupExpression
extends Expression {
    private String expression;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;
    private double[] points;

    public LookupExpression(String expression, double xMin, double yMin, double xMax, double yMax, double[] points) {
        this.expression = expression;
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.points = points;
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        StringBuilder lookup = new StringBuilder();
        lookup.append('{');
        int i = 0;
        while (i < this.points.length / 2) {
            if (i > 0) {
                lookup.append(',');
            }
            lookup.append('{').append(this.points[2 * i]).append(',').append(this.points[2 * i + 1]).append('}');
            ++i;
        }
        lookup.append('}');
        Resource expr = super.write(graph, parent, context);
        graph.claimLiteral(expr, sr.WithLookupExpression_expression, (Object)this.expression, (Binding)Bindings.STRING);
        graph.claimLiteral(expr, sr.WithLookupExpression_lookup, (Object)lookup.toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(expr, sr.WithLookupExpression_minX, (Object)this.xMin, (Binding)Bindings.DOUBLE);
        graph.claimLiteral(expr, sr.WithLookupExpression_minY, (Object)this.yMin, (Binding)Bindings.DOUBLE);
        graph.claimLiteral(expr, sr.WithLookupExpression_maxX, (Object)this.xMax, (Binding)Bindings.DOUBLE);
        graph.claimLiteral(expr, sr.WithLookupExpression_maxY, (Object)this.yMax, (Binding)Bindings.DOUBLE);
        return expr;
    }

    @Override
    public Resource getExpressionType(ReadGraph graph) {
        return SysdynResource.getInstance((ReadGraph)graph).WithLookupExpression;
    }

    @Override
    public String getExpressionTypeString() {
        return "WithLookupExpression";
    }
}

