/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.AbstractPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.adapter.VariableValueSubscription;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.manager.VariableSubscriptionManager;
import org.simantics.utils.datastructures.Pair;

public abstract class IndexVariable<T>
extends AbstractPropertyVariable {
    protected Variable parent;
    protected SysdynModel model;
    protected SysdynExperiment experiment;
    protected String rvi;
    protected HashMap<String, String> rvis;
    protected String indexes;
    protected VariableSubscriptionManager subscriptionManager;
    private Pair<List<String>, List<String>> variableNameArrays;

    public IndexVariable(ReadGraph graph, Variable parent, String indexes) throws DatabaseException {
        this.parent = parent;
        this.indexes = indexes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexVariable other = (IndexVariable)((Object)obj);
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    protected VariableSubscriptionManager getSubscriptionManager() {
        return this.experiment;
    }

    public String getIndexes() {
        return this.indexes;
    }

    protected VariableValueSubscription<T> registerSubscription(ExternalRead<?> request, Listener<T> procedure) {
        VariableValueSubscription<T> subscription = new VariableValueSubscription<T>(request, this, procedure);
        if (this.subscriptionManager != null) {
            this.subscriptionManager.addVariableValueSubscription(subscription);
        }
        subscription.update();
        return subscription;
    }

    protected void unregisterSubscription(VariableValueSubscription<T> subscription) {
        subscription.setListener(null);
        if (this.subscriptionManager != null) {
            this.subscriptionManager.removeVariableValueSubscription(subscription);
        }
    }

    public Resource getPropertyResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Resource getContainerResource(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public Variable getPredicate(ReadGraph graph) throws DatabaseException {
        return null;
    }

    public <U> U getValue(ReadGraph graph) throws DatabaseException {
        return this.getValue(graph, (Binding)Bindings.DOUBLE);
    }

    public <U> U getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        this.ensureInformationAvailable(graph);
        this.beforeRequest(graph);
        return (U)graph.syncRequest(new PropertyRequest(this));
    }

    protected void beforeRequest(ReadGraph graph) throws DatabaseException {
    }

    protected void ensureInformationAvailable(ReadGraph graph) throws DatabaseException {
        SimulationResource SIMU;
        if (this.model == null) {
            SIMU = SimulationResource.getInstance((ReadGraph)graph);
            Resource modelResource = Variables.getModel((ReadGraph)graph, (Variable)this.parent);
            Resource configuration = graph.getPossibleObject(modelResource, SIMU.HasConfiguration);
            this.model = SysdynModelManager.getInstance(graph.getSession()).getModel(graph, configuration);
        }
        if (this.experiment == null || this.subscriptionManager == null) {
            IExperimentManager expMan;
            IExperiment e;
            SIMU = SimulationResource.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Variable var = this.parent.getParent(graph);
            Resource represents = var.getRepresents(graph);
            Resource activeRun = null;
            if (represents != null) {
                do {
                    if (!graph.isInstanceOf(represents, SIMU.Run)) continue;
                    activeRun = represents;
                    break;
                } while ((represents = (var = var.getParent(graph)).getRepresents(graph)) != null && !graph.isInstanceOf(represents, MOD.StructuralModel));
            }
            IProject project = Simantics.peekProject();
            if (activeRun != null && project != null && (e = (expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER)).getExperiment(NameUtils.getSafeName((ReadGraph)graph, (Resource)activeRun))) instanceof SysdynExperiment) {
                this.experiment = (SysdynExperiment)e;
            }
            this.subscriptionManager = this.getSubscriptionManager();
        }
        if (this.rvi == null) {
            this.rvi = Variables.getPossibleRVI((ReadGraph)graph, (Variable)this);
        }
        if (this.rvi != null) {
            this.rvis = (HashMap)graph.syncRequest((Read)new VariableRVIUtils.GetActiveRVIs(this.parent.getParent(graph)));
        }
    }

    private Pair<List<String>, List<String>> getVariableNameArrays() {
        if (this.variableNameArrays == null && this.rvi != null && this.rvis != null) {
            if (this.rvi.indexOf(35) > 0) {
                this.rvi = this.rvi.substring(0, this.rvi.indexOf(35));
            }
            boolean regexp = false;
            String test = this.rvi;
            if (this.indexes != null && !this.indexes.isEmpty()) {
                regexp = this.indexes.contains(":");
                if (regexp) {
                    String regexIndexes = this.indexes.trim().replaceAll(":", "[a-zA-Z0-9_]*");
                    test = String.valueOf(this.rvi) + "\\[" + regexIndexes + "\\]";
                } else {
                    test = String.valueOf(this.rvi) + "[" + this.indexes + "]";
                }
            } else {
                test = String.valueOf(this.rvi) + "(\\[.*\\])?";
                regexp = true;
            }
            Pair result = null;
            if (regexp) {
                Pattern p = Pattern.compile(test);
                result = new Pair(new ArrayList(), new ArrayList());
                for (String k : this.rvis.keySet()) {
                    String value = this.rvis.get(k);
                    if (!p.matcher(k).matches() && !p.matcher(value).matches()) continue;
                    ((List)result.first).add(this.transform(k));
                    ((List)result.second).add(this.transform(value));
                }
            } else {
                String value = this.rvis.get(test);
                if (value != null) {
                    result = new Pair(Collections.singletonList(this.transform(test)), Collections.singletonList(this.transform(value)));
                } else {
                    for (String k : this.rvis.keySet()) {
                        value = this.rvis.get(k);
                        if (!value.equals(test)) continue;
                        result = new Pair(Collections.singletonList(this.transform(k)), Collections.singletonList(this.transform(test)));
                        break;
                    }
                }
            }
            this.variableNameArrays = result;
        }
        if (this.variableNameArrays == null) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        return this.variableNameArrays;
    }

    private String transform(String s) {
        return s.substring(1).replace("/", ".").replace("%20", "_");
    }

    protected List<String> getVariableNames() {
        return (List)this.getVariableNameArrays().second;
    }

    protected List<String> getVariableNamesWithIndexNumbers() {
        return (List)this.getVariableNameArrays().first;
    }

    public abstract T getValue();

    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.ensureInformationAvailable((ReadGraph)graph);
        this.setIndexedValue(graph, value);
    }

    protected abstract void setIndexedValue(WriteGraph var1, Object var2) throws DatabaseException;

    public String getName(ReadGraph graph) throws DatabaseException {
        return this.indexes;
    }

    public Variable getParent(ReadGraph graph) throws DatabaseException {
        return this.parent;
    }

    public int getPublishCounter(ReadGraph graph) throws DatabaseException {
        if (this.experiment instanceof OldSysdynExperiment) {
            return ((OldSysdynExperiment)this.experiment).getPublishCounter(graph);
        }
        return 0;
    }

    static class PropertyRequest<T>
    extends ParametrizedPrimitiveRead<IndexVariable, T> {
        VariableValueSubscription<T> subscription;

        public PropertyRequest(IndexVariable indexVariable) {
            super((Object)indexVariable);
        }

        public void register(ReadGraph graph, Listener<T> procedure) {
            if (this.subscription != null) {
                System.err.println("err!");
            }
            this.subscription = ((IndexVariable)((Object)this.parameter)).registerSubscription((ExternalRead<?>)this, procedure);
        }

        public void unregistered() {
            if (this.subscription != null) {
                ((IndexVariable)((Object)this.parameter)).unregisterSubscription(this.subscription);
                this.subscription = null;
            }
        }

        public String toString() {
            return "PropertyRequest[" + ((IndexVariable)((Object)this.parameter)).rvi + "]";
        }
    }
}

