/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types.util;

import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;

public class TypeTree<T> {
    Node<T> root;

    public TypeTree(Case<T>[] cases) {
        this.root = new Node<T>(cases);
    }

    public Iterator<T> iterator(Type ... scrutinee) {
        return new Iterator<T>(this.root, scrutinee);
    }

    private static class Branch<T> {
        private Branch() {
        }

        public void improve(Iterator<T> iterator) {
        }
    }

    public static class Case<T> {
        public Type[] types;
        public T result;
    }

    public static class Iterator<T> {
        Node<T> node;
        Type[] scrutinee;

        public Iterator(Node<T> node, Type[] scrutinee) {
            this.node = node;
            this.scrutinee = scrutinee;
        }

        public void improve() {
            int i = 0;
            while (i < this.scrutinee.length) {
                Branch<T> branch;
                this.scrutinee[i] = Skeletons.canonicalSkeleton(this.scrutinee[i]);
                Type type = this.scrutinee[i];
                if (!(type instanceof TMetaVar) && (branch = this.node.getBranch(i)) != null) {
                    branch.improve(this);
                    --i;
                }
                ++i;
            }
        }
    }

    private static class Node<T> {
        Case<T>[] cases;
        Branch<T>[] branches;

        public Node(Case<T>[] cases) {
            this.cases = cases;
            this.branches = new Branch[cases[0].types.length];
        }

        Branch<T> getBranch(int i) {
            return null;
        }
    }
}

